/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.sal.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.commons.service.ActivityAccessLogService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityAccessLogServiceImpl
implements ActivityAccessLogService {
    @Autowired
    private ActivityAccessLogDao accessLogDao;

    @Override
    public List<DairyCountStatistics> getLastDayLog(Long activityId, List<String> dateList, TemplateTypeCategory category) {
        List list = this.accessLogDao.selectActivityAccessLogByDate(dateList, activityId, category.getType());
        ArrayList<DairyCountStatistics> statisticsList = new ArrayList<DairyCountStatistics>();
        if (list != null && list.size() > 0) {
            for (ActivityAccessLog log : list) {
                statisticsList.add(new DairyCountStatistics(log.getAccessDate(), log.getAccessCount()));
            }
        }
        return statisticsList;
    }

    @Override
    public int getTotalAccessCount(Long activityId, TemplateTypeCategory category) {
        Map map = this.accessLogDao.selectTotalByActivityId(Arrays.asList(activityId), category.getType());
        return map.get(activityId) == null ? 0 : (Integer)map.get(activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="yunyingTransactionManager")
    public void setTodayAccessCount(Long activityId, TemplateTypeCategory category) {
        String dateStr = DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd");
        List accessLogs = this.accessLogDao.selectActivityAccessLogByDate(Arrays.asList(dateStr), activityId, category.getType());
        if (accessLogs == null || accessLogs.isEmpty()) {
            ActivityAccessLogServiceImpl activityAccessLogServiceImpl = this;
            synchronized (activityAccessLogServiceImpl) {
                accessLogs = this.accessLogDao.selectActivityAccessLogByDate(Arrays.asList(dateStr), activityId, category.getType());
                if (accessLogs == null || accessLogs.isEmpty()) {
                    ActivityAccessLog log = new ActivityAccessLog();
                    log.setAccessCount(1);
                    log.setAccessDate(dateStr);
                    log.setActivityId(activityId.longValue());
                    log.setUpdateTime(new Date());
                    log.setCategory(category.getType());
                    this.accessLogDao.insertActivityAccessLog(log);
                } else {
                    this.accessLogDao.updateActivityAccessLog(activityId, dateStr);
                }
            }
        } else {
            this.accessLogDao.updateActivityAccessLog(activityId, dateStr);
        }
    }
}

