/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.activity.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.sal.activity.dto.ActivityEnrollDto;
import com.baijia.tianxiao.sal.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.activity.service.EnrollService;
import com.baijia.tianxiao.sal.commons.enums.ResultType;
import com.baijia.tianxiao.sal.commons.utils.JsonToMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnrollServiceImpl
implements EnrollService {
    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private ActivityConfDao confDao;
    @Autowired
    private ActivityDao activityDao;

    @Override
    public List<ActivityEnrollDto> getEnrollList(long activityId, PageInfo page) {
        List enrolls = this.enrollDao.selectEnrollsByActivityId(activityId, page);
        if (enrolls == null || enrolls.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<ActivityEnrollDto> dtos = new ArrayList<ActivityEnrollDto>(enrolls.size());
        for (ActivityEnroll enroll : enrolls) {
            dtos.add(ActivityEnrollDto.getInstance(enroll));
        }
        return dtos;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ResultWrapper<Object> addEnroll(ActivityEnroll enroll) {
        ResultWrapper<Object> ret = this.validateActivityEnroll(enroll);
        if (ret.getRetType() == ResultType.SUCC) {
            enroll.setCreateTime(new Timestamp(new Date().getTime()));
            this.enrollDao.insertEnroll(enroll);
        }
        return ret;
    }

    private ResultWrapper<Object> validateActivityEnroll(ActivityEnroll enroll) {
        ResultWrapper<Object> ret = new ResultWrapper<Object>();
        Activity activity = this.activityDao.getActivityById(Long.valueOf(enroll.getActivityId()));
        ActivityConf conf = this.confDao.getConfigByActivityId(enroll.getActivityId());
        if (activity == null || conf == null) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6d3b\u52a8ID");
            return ret;
        }
        int enrolledCount = this.enrollDao.getEnrollCount(enroll.getActivityId());
        if (conf.getCountLimit() <= enrolledCount) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("\u540d\u989d\u5df2\u62a5\u6ee1\uff0c\u8bf7\u671f\u5f85\u4e0b\u6b21");
            return ret;
        }
        if (conf.getReportEndTime().before(new Date())) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("\u62a5\u540d\u5df2\u7ed3\u675f,\u8bf7\u671f\u5f85\u4e0b\u6b21");
            return ret;
        }
        Map<String, Object> map = JsonToMap.toMap(enroll.getContent());
        String mobile = (String)map.get("mobile");
        if (StringUtils.isBlank((String)mobile)) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return ret;
        }
        if (this.isExistedMobile(enroll.getActivityId(), mobile)) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u62a5\u540d");
            return ret;
        }
        return ret;
    }

    private boolean isExistedMobile(long activityId, String mobile) {
        ActivityEnroll enroll = this.enrollDao.selectEnrollByMobile(activityId, mobile);
        return enroll != null;
    }
}

