/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.activity.dto;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityBaseInfo {
    private static final Logger log = LoggerFactory.getLogger(ActivityBaseInfo.class);
    private Long id;
    private String name;
    private int browseCount;
    private int enrollCount;
    private int status;
    private Long createTime;
    private int templateId;
    private int templateTypeId;
    private Long updateTime;

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public int getTemplateTypeId() {
        return this.templateTypeId;
    }

    public void setTemplateTypeId(int templateTypeId) {
        this.templateTypeId = templateTypeId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getBrowseCount() {
        return this.browseCount;
    }

    public void setBrowseCount(int browseCount) {
        this.browseCount = browseCount;
    }

    public int getEnrollCount() {
        return this.enrollCount;
    }

    public void setEnrollCount(int enrollCount) {
        this.enrollCount = enrollCount;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public static ActivityBaseInfo getInstance(Activity activity, ActivityConf conf) {
        ActivityBaseInfo baseInfo = null;
        if (activity != null && conf != null) {
            baseInfo = new ActivityBaseInfo();
            baseInfo.setId(activity.getId());
            baseInfo.setName(activity.getTitle());
            baseInfo.setStatus(activity.getSwitcher());
            baseInfo.setBrowseCount(activity.getSupportNum());
            if (conf.getEndTime().before(new Date()) && activity.getSwitcher() == 1) {
                baseInfo.setStatus(0);
            } else {
                baseInfo.setStatus(activity.getSwitcher());
            }
            baseInfo.setCreateTime(DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)activity.getCreateTime()).getTime());
            baseInfo.setUpdateTime(DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)activity.getUpdateTime()).getTime());
            try {
                baseInfo.setCreateTime(DateUtils.parseDate((String)activity.getCreateTime(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).getTime());
            }
            catch (ParseException e) {
                log.error("ParseException", (Throwable)e);
                e.printStackTrace();
            }
            baseInfo.setTemplateId(conf.getTemplateId());
        }
        return baseInfo;
    }
}

