/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.utils;

import com.baijia.tianxiao.sal.marketing.article.utils.ImageUtil;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.utils.QRCodeUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(QrCodeUtil.class);

    public static String replaceWechatImgUrl(String html) {
        if (StringUtils.isBlank((String)html)) {
            return "";
        }
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img[data-src]");
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                if (!StringUtils.isNotBlank((String)((Element)elements.get(i)).attr("data-src"))) continue;
                String attr = ((Element)elements.get(i)).attr("data-src");
                attr = attr.replace("http://mmbiz.qpic.cn", Config.DOMAIN + "/wechatImg");
                log.info("[Wechat] image url=" + attr);
                ((Element)elements.get(i)).attr("data-src", attr);
            }
        }
        return document.toString();
    }

    public static String deleteQrCodeEffecient(String html) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements != null && elements.size() > 0) {
            int i = elements.size() - 1;
            while (i >= 0) {
                if (QrCodeUtil.isQrCode((Element)elements.get(i))) {
                    ((Element)elements.get(i)).remove();
                    int j = i - 1;
                    if (j >= 0 && !QrCodeUtil.isQrCode((Element)elements.get(j))) break;
                    if (j >= 0) {
                        ((Element)elements.get(j)).remove();
                        i = j - 1;
                        continue;
                    }
                    --i;
                    continue;
                }
                --i;
            }
        }
        return document.toString();
    }

    public static boolean isQrCode(Element element) {
        if (StringUtils.isNotBlank((String)element.attr("data-src"))) {
            String attr = element.attr("data-src");
            String srcUrl = attr.trim();
            srcUrl = srcUrl.replaceAll("(.*)\\?.*", "$1");
            try {
                boolean isQrCode = QrCodeUtil.qrCodeCheck(srcUrl);
                return isQrCode;
            }
            catch (NotFoundException isQrCode) {
            }
            catch (ReaderException e) {
                log.warn("[ReaderException]", (Object)e.getMessage());
            }
            catch (Exception e) {
                log.warn("[OtherException]", (Object)e.getMessage());
            }
        }
        return false;
    }

    public static boolean qrCodeCheck(String srcUrl) throws Exception {
        String text = null;
        BufferedImage bufferedImage = QrCodeUtil.downImageAndReturn(srcUrl);
        try {
            text = QRCodeUtils.decode(bufferedImage);
            System.out.println(URLEncoder.encode(text, "utf-8"));
        }
        catch (Exception e) {
            log.warn("exception : ", (Throwable)e);
        }
        return StringUtils.isNotBlank((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage downImageAndReturn(String src) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(src);
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                BufferedImage bufferedImage;
                InputStream input = entity.getContent();
                String ext = null;
                Header[] headers = response.getHeaders("Content-Type");
                if (GenericsUtils.notNullAndEmpty((Object)headers)) {
                    String type = headers[0].getValue();
                    ext = QrCodeUtil.getExt(type);
                }
                if (ext.equalsIgnoreCase(".gif")) {
                    bufferedImage = ImageUtil.getGifFirstFrame(input, 1);
                    return bufferedImage;
                }
                bufferedImage = ImageIO.read(input);
                return bufferedImage;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downImageFile(String src) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(src);
        File file = null;
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream input = entity.getContent();
                String ext = null;
                Header[] headers = response.getHeaders("Content-Type");
                if (GenericsUtils.notNullAndEmpty((Object)headers)) {
                    String type = headers[0].getValue();
                    ext = QrCodeUtil.getExt(type);
                }
                file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString() + ext);
                FileOutputStream output = new FileOutputStream(file);
                byte[] buffer = new byte[(int)entity.getContentLength()];
                IOUtils.readFully((InputStream)input, (byte[])buffer);
                IOUtils.write((byte[])buffer, (OutputStream)output);
                File file2 = file;
                return file2;
            }
        }
        return null;
    }

    private static String getExt(String type) {
        if (type.equalsIgnoreCase("image/gif")) {
            return ".gif";
        }
        if (type.equalsIgnoreCase("image/jpeg")) {
            return ".jpeg";
        }
        if (type.equalsIgnoreCase("image/png")) {
            return ".png";
        }
        return ".png";
    }

    @Test
    public void testQrCode() throws Exception {
        String url = "http://img.blog.csdn.net/20150504161653341?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvY2xhc3NfaG9yc2U=/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/Center";
        boolean isQrCode = QrCodeUtil.qrCodeCheck(url);
        System.out.println(isQrCode);
    }

    public static void main(String[] args) throws Exception {
        byte[] resource = HttpClientUtils.download((String)"http://img.blog.csdn.net/20150504161653341?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvY2xhc3NfaG9yc2U=/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/Center");
        String content = new String(resource, "utf-8");
        long beginTime = System.currentTimeMillis();
        String deleteQrCode = QrCodeUtil.deleteQrCodeEffecient(content);
        System.out.println("result is : " + deleteQrCode);
        long endTime = System.currentTimeMillis();
        System.out.print("use time : " + (endTime - beginTime));
    }
}

