/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.activity.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityBaseInfo;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityConfigDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityRequest;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySearchRequest;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityService;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.ActivityAccessLogService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityServiceImpl
implements ActivityService {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;
    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private ActivityAccessLogService accessLogService;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ActivityDetailDto saveOrgActivity(ActivitySearchRequest request, Integer orgId) {
        Activity activity = this.construct(request, orgId);
        activity.setSwitcher(Integer.valueOf(1));
        Long aId = this.activityDao.saveActivity(activity);
        activity.setId(aId);
        ActivityConf saveActivityConf = this.toActivityConf(request.getConfig());
        saveActivityConf.setActivityId(aId);
        saveActivityConf.setOrgId(orgId);
        this.activityConfDao.saveActivityConf(saveActivityConf);
        ActivitySearchRequest searchRequest = new ActivitySearchRequest();
        searchRequest.setId(aId);
        searchRequest.setOrgId(orgId.longValue());
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId().longValue()));
        return this.getActivityDetail(searchRequest);
    }

    @Override
    public List<ActivityBaseInfo> getActivitiesByOrgId(ActivitySearchRequest searchRequest) {
        List activities = this.activityDao.listActivities(searchRequest.getStatus(), searchRequest.getId(), Integer.valueOf(searchRequest.getOrgId().intValue()), searchRequest.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)searchRequest)) {
            return Collections.emptyList();
        }
        HashSet<Long> activityIds = new HashSet<Long>();
        ArrayList<ActivityBaseInfo> baseInfoList = new ArrayList<ActivityBaseInfo>();
        for (Activity activity : activities) {
            activityIds.add(activity.getId());
        }
        Map map = this.activityConfDao.getConfigMapByActivityIds(activityIds);
        for (Activity activity : activities) {
            ActivityConf conf = (ActivityConf)map.get(activity.getId());
            ActivityBaseInfo info = ActivityBaseInfo.getInstance(activity, conf);
            int enrollCount = this.enrollDao.getEnrollCount(activity.getId().longValue());
            info.setEnrollCount(enrollCount);
            baseInfoList.add(info);
        }
        return baseInfoList;
    }

    private ActivityConf toActivityConf(ActivityConfigDto config) {
        ActivityConf tempConfig = new ActivityConf();
        tempConfig.setAddress(config.getAddress());
        tempConfig.setAreaId(config.getAreaId());
        tempConfig.setCountLimit(config.getCountLimit());
        tempConfig.setDisplay(Integer.valueOf(config.getDisplay()));
        tempConfig.setLatitude(config.getLatitude());
        tempConfig.setLongitude(config.getLongitude());
        tempConfig.setCustomConf(config.getCustomConf());
        tempConfig.setStartTime(this.getTime(config.getStartTime()));
        tempConfig.setEndTime(this.getTime(config.getEndTime()));
        tempConfig.setReportEndTime(this.getTime(config.getEnrollDeadline()));
        tempConfig.setTemplateTypeId(config.getTemplateTypeId());
        tempConfig.setTemplateId(config.getTemplateId());
        return tempConfig;
    }

    private Timestamp getTime(Long time) {
        if (time == null) {
            return null;
        }
        return new Timestamp(time);
    }

    private Activity construct(ActivitySearchRequest request, Integer orgId) {
        Activity activity = new Activity();
        activity.setOrgId(orgId);
        activity.setAuditstatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        activity.setBbType(ActivityRequest.BB_TYPE);
        activity.setContent(request.getContent());
        Date date = new Date();
        activity.setCreateTime(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        activity.setcType(ActivityRequest.C_TYPE);
        activity.setStorageId(Long.valueOf(-1L));
        activity.setrType(Integer.valueOf(-1));
        activity.setSync(Integer.valueOf(-1));
        activity.setTitle(request.getName());
        activity.setStick(Integer.valueOf(1));
        activity.setSupportNum(Integer.valueOf(0));
        activity.setSwitcher(request.getStatus());
        return activity;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void deleteActivity(ActivitySearchRequest searchRequest) {
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), searchRequest.getOrgId());
        if (activity != null) {
            activity.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
            activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(activity);
        } else {
            this.logger.info("");
        }
    }

    @Override
    public ActivityDetailDto getActivityDetail(ActivitySearchRequest searchRequest) {
        Long orgId = searchRequest.getOrgId();
        if (orgId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), orgId);
        this.logger.info("find activity {}", (Object)activity);
        if (activity == null) {
            return null;
        }
        Map confMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(searchRequest.getId()));
        int enrollCount = this.enrollDao.getEnrollCount(activity.getId().longValue());
        this.logger.info("confMap is :{}", (Object)confMap);
        if (confMap != null) {
            this.logger.info("confMap2 is :{}", (Object)confMap);
            if (confMap.get(searchRequest.getId()) != null) {
                this.logger.info("build response with activity and acitvity'conf {} , {} ", (Object)activity, confMap.get(searchRequest.getId()));
                ActivityDetailDto buildResponse = ActivityDetailDto.buildResponse(activity, (ActivityConf)confMap.get(searchRequest.getId()));
                buildResponse.setEnrollCount(enrollCount);
                return buildResponse;
            }
            this.logger.info("not find any conf ");
            ActivityDetailDto buildResponse = ActivityDetailDto.buildResponse(activity);
            buildResponse.setCustomConf(new Object());
            buildResponse.setEnrollCount(enrollCount);
            return buildResponse;
        }
        return null;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ActivityDetailDto update(ActivitySearchRequest searchRequest) {
        Long orgId = searchRequest.getOrgId();
        if (orgId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), orgId);
        if (activity != null) {
            Activity updateActivity = this.construct(searchRequest, activity.getOrgId());
            updateActivity.setId(activity.getId());
            updateActivity.setOrgId(activity.getOrgId());
            updateActivity.setSupportNum(activity.getSupportNum());
            updateActivity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(updateActivity);
            ActivityConfigDto configDto = searchRequest.getConfig();
            configDto.setDisplay(searchRequest.getStatus() == null ? 1 : searchRequest.getStatus());
            ActivityConf newConf = this.toActivityConf(configDto);
            ActivityConf sourceConf = this.activityConfDao.getConfigByActivityId(activity.getId().longValue());
            if (sourceConf == null) {
                this.logger.error("[ActivityConf] conf is not exist.activityId = " + activity.getId());
                return null;
            }
            newConf.setId(sourceConf.getId());
            if (newConf.getStartTime() == null) {
                newConf.setStartTime(sourceConf.getStartTime());
            }
            this.activityConfDao.updateActivityConf(newConf);
            if (searchRequest.getTemplateId() != null) {
                this.templateDao.updateTemplateUseCount(Long.valueOf(searchRequest.getTemplateId().longValue()));
            }
            return this.getActivityDetail(searchRequest);
        }
        return null;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void incrBrowseCount(Long activityId, Integer orgId) {
        Activity activity = this.activityDao.getActivityByIdAndOrgId(activityId, orgId);
        if (activity != null) {
            Integer browseCount = activity.getSupportNum();
            if (browseCount == null) {
                browseCount = 1;
            } else {
                Integer n = browseCount;
                Integer n2 = browseCount = Integer.valueOf(browseCount + 1);
            }
            activity.setSupportNum(browseCount);
            activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(activity);
            this.accessLogService.setTodayAccessCount(activityId, TemplateTypeCategory.COMMON_TYPE);
        }
    }
}

