/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.commons.constants.Config;
import com.baijia.tianxiao.sal.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.commons.enums.EmailType;
import com.baijia.tianxiao.sal.commons.enums.Status;
import com.baijia.tianxiao.sal.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.commons.service.RedisService;
import com.baijia.tianxiao.sal.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.commons.utils.ExcelHelper;
import com.baijia.tianxiao.sal.commons.utils.Mail;
import com.baijia.tianxiao.sal.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.commons.utils.NumberFormat;
import com.baijia.tianxiao.sal.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.draw.dto.DrawActivityDetail;
import com.baijia.tianxiao.sal.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.draw.dto.DrawActivityResponse;
import com.baijia.tianxiao.sal.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.draw.dto.DrawResult;
import com.baijia.tianxiao.sal.draw.enums.DrawCode;
import com.baijia.tianxiao.sal.draw.service.ActivityUserService;
import com.baijia.tianxiao.sal.draw.service.DrawPrizesService;
import com.baijia.tianxiao.sal.draw.service.DrawService;
import com.baijia.tianxiao.sal.draw.service.WinnerService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.mail.Session;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DrawServiceImpl
implements DrawService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private DrawPrizesService drawPrizesService;
    @Autowired
    private ActivityUserService activityUserService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private WinnerService winnerService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private ActivityAccessLogDao accessLogDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private PrizeInfoDao prizeInfoDao;
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private FansService fansService;
    @Autowired
    private TemplateDao templateDao;
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawActivityBase addDrawActivity(DrawActivityRequest request) {
        TwoTuple<DrawInfo, List<PrizeInfo>> buildDetailPo = DrawActivityDetail.buildDetailPo(request);
        DrawInfo di = (DrawInfo)buildDetailPo.first;
        di.setStatus(Integer.valueOf(1));
        Long current = new Date().getTime();
        Timestamp currentTimestamp = new Timestamp(current);
        di.setCreateTime(currentTimestamp);
        di.setUpdateTime(currentTimestamp);
        Long activityId = this.drawActivityDao.addDrawActivity(di);
        List prizeInfos = (List)buildDetailPo.second;
        if (GenericsUtils.notNullAndEmpty((Object)prizeInfos)) {
            for (PrizeInfo pi : prizeInfos) {
                pi.setActivityId(activityId);
            }
            this.drawPrizesService.addPrizeInfo(prizeInfos);
        }
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId().longValue()));
        try {
            this.logger.info("[Param]=" + ToStringBuilder.reflectionToString((Object)request));
            Template template = this.templateDao.selectTemplateById(request.getTemplateId());
            CustomActivityDto wechat = this.customActivityService.createCustomActivity(request.getOrgId().intValue(), activityId.intValue(), 99, request.getName(), request.getIntroduction(), template.getThumbNail());
            if (wechat == null) {
                throw new RuntimeException("\u521b\u5efa\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("[DrawActivity] create error.", (Throwable)e);
            throw new RuntimeException("\u521b\u5efa\u6d3b\u52a8\u5931\u8d25");
        }
        request.setActivityId(activityId);
        return this.activityDetail(request);
    }

    @Override
    public DrawActivityDetail activityDetail(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        DrawInfo di = this.drawActivityDao.getDrawInfoDetail(activityId, null);
        if (di == null) {
            return null;
        }
        List<PrizeInfo> prizeInfos = this.drawPrizesService.getPrizeInfosByActivityId(activityId);
        DrawActivityDetail detail = DrawActivityDetail.buildDetailDto(di, prizeInfos);
        this.setStatistical(Arrays.asList(detail));
        DrawActivityResponse dar = new DrawActivityResponse();
        try {
            BeanUtils.copyProperties((Object)dar, (Object)detail);
            dar.setPrizes(dar.getPrizeList());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.logger.error("error : ", (Throwable)e);
        }
        String url = Config.DOMAIN + "/draw.html?activityId=" + detail.getActivityId() + "#!/";
        dar.setUrl(url);
        return dar;
    }

    private void setStatistical(List<? extends DrawActivityBase> baseInfos) {
        if (baseInfos == null) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(baseInfos.size());
        for (DrawActivityBase drawActivityBase : baseInfos) {
            list.add(drawActivityBase.getActivityId());
        }
        Map accessMap = this.accessLogDao.selectTotalByActivityId(list, TemplateTypeCategory.DRAW_TYPE.getType());
        Map map = this.activityUserDao.selectTotalByActivityId(list);
        Map winnerMap = this.winnerDao.selectTotalByActivityId(list);
        for (DrawActivityBase drawActivityBase : baseInfos) {
            Integer browseCount = (Integer)accessMap.get(drawActivityBase.getActivityId());
            Integer userCount = (Integer)map.get(drawActivityBase.getActivityId());
            Integer winnerCount = (Integer)winnerMap.get(drawActivityBase.getActivityId());
            drawActivityBase.setBrowseCount(browseCount == null ? 0 : browseCount);
            drawActivityBase.setUserCount(userCount == null ? 0 : userCount);
            drawActivityBase.setWinnerCount(winnerCount == null ? 0 : winnerCount);
        }
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawActivityDetail modifyActivity(DrawActivityRequest request) {
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(request.getActivityId(), request.getOrgId());
        if (drawInfo == null) {
            this.logger.warn("[Draw] Draw is not exist.activityId=" + request.getActivityId());
            return null;
        }
        this.logger.info("[Param]= request" + ToStringBuilder.reflectionToString((Object)request));
        TwoTuple<DrawInfo, List<PrizeInfo>> buildDetailPo = DrawActivityDetail.buildDetailPo(request);
        DrawInfo di = (DrawInfo)buildDetailPo.first;
        Long current = new Date().getTime();
        Timestamp currentTimestamp = new Timestamp(current);
        di.setUpdateTime(currentTimestamp);
        this.drawActivityDao.updateDrawActivity(di);
        List prizeInfos = (List)buildDetailPo.second;
        this.logger.info("[Param]= prizeInfos" + ToStringBuilder.reflectionToString((Object)prizeInfos));
        if (GenericsUtils.notNullAndEmpty((Object)prizeInfos)) {
            Long activityId = request.getActivityId();
            for (PrizeInfo pi : prizeInfos) {
                pi.setActivityId(activityId);
            }
            this.drawPrizesService.updatePrizes(activityId, prizeInfos);
        }
        this.templateDao.updateTemplateUseCount(Long.valueOf(drawInfo.getTemplateId().longValue()));
        DrawCacheDto cacheDto = this.redisService.getDrawActivityBase(request.getActivityId());
        if (cacheDto != null) {
            this.redisService.setDrawActivityBase(request.getActivityId(), this.getDrawCacheDtoFromDbById(request.getActivityId()));
        }
        return this.activityDetail(request);
    }

    @Override
    public List<DrawActivityBase> activityList(DrawActivityRequest request) {
        List listDrawActivity = this.drawActivityDao.listDrawActivity(request.getStatus(), request.getLastId(), request.getOrgId(), request.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)listDrawActivity)) {
            return Collections.emptyList();
        }
        ArrayList<DrawActivityBase> baseInfos = new ArrayList<DrawActivityBase>(listDrawActivity.size());
        for (DrawInfo di : listDrawActivity) {
            DrawActivityBase baseInfo = new DrawActivityBase().buildDto(di);
            baseInfos.add(baseInfo);
        }
        this.setStatistical(baseInfos);
        return baseInfos;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public boolean modifyStatus(DrawActivityRequest request) {
        DrawInfo di = request.buildPo();
        this.logger.info("[ModifyStatus]" + di.getStatus());
        try {
            di.setUpdateTime(new Timestamp(new Date().getTime()));
            this.drawActivityDao.updateDrawActivity(di);
            DrawCacheDto cacheDto = this.redisService.getDrawActivityBase(request.getActivityId());
            if (cacheDto != null) {
                cacheDto.setStatus(request.getStatus());
                this.logger.info("[ModifyStatus] Cache=" + request.getStatus());
                this.redisService.setDrawActivityBase(request.getActivityId(), cacheDto);
            }
            return true;
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return false;
        }
    }

    @Override
    public TwoTuple<Integer, String> exportUserList(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            this.logger.info("can not find an org with org_ID {}", (Object)orgId);
            return TupleUtil.tuple(400, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String orgName = simple.getShortName();
        String email = request.getEmail();
        return this.createPartakeStatisticsMail(orgId, activityId, orgName, email);
    }

    private TwoTuple<Integer, String> createPartakeStatisticsMail(Long orgId, Long activityId, String orgName, String email) {
        List<DairyCountStatistics> activityUserStatistics = this.activityUserService.getActivityUserStatistics(activityId, orgId);
        if (GenericsUtils.isNullOrEmpty(activityUserStatistics)) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u6682\u65e0\u53c2\u4e0e\u7528\u6237");
        }
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(drawInfo.getOrgId(), activityId, drawInfo.getTemplateTypeId(), EmailType.USER);
        if (!isNotLimited) {
            this.logger.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5");
        }
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (DairyCountStatistics statistics : activityUserStatistics) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            String data = statistics.getDate();
            String count = String.valueOf(statistics.getCount());
            rowMap.put("\u65e5\u671f", data);
            rowMap.put("\u53c2\u4e0e\u8005", count);
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_RRAW_SUBJECT_PARTAKE.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_PARTAKE.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        this.sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple(TupleUtil.OK, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    @Override
    public TwoTuple<Integer, String> exportWinnerList(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        Long orgId = request.getOrgId();
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            this.logger.info("can not find an org with org_ID {}", (Object)orgId);
            return TupleUtil.tuple(400, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String orgName = simple.getShortName();
        String email = request.getEmail();
        return this.createWinnerStatisticsMail(orgId, activityId, orgName, email);
    }

    private TwoTuple<Integer, String> createWinnerStatisticsMail(Long orgId, Long activityId, String orgName, String email) {
        List<Winner> winnerStatistics = this.winnerService.getWinnerList(activityId, null);
        if (GenericsUtils.isNullOrEmpty(winnerStatistics)) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u6682\u65e0\u4e2d\u5956\u7528\u6237");
        }
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(drawInfo.getOrgId(), activityId, drawInfo.getTemplateTypeId(), EmailType.WINNER);
        if (!isNotLimited) {
            this.logger.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return TupleUtil.tuple(TupleUtil.NO_OK, "\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5");
        }
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (Winner winner : winnerStatistics) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            String grade = NumberFormat.numToWord(winner.getGrade()) + "\u7b49\u5956";
            rowMap.put("\u7f16\u53f7", String.valueOf(winner.getDrawId()));
            rowMap.put("\u5956\u54c1\u7b49\u7ea7", grade);
            rowMap.put("\u5956\u54c1\u540d\u79f0", winner.getPrizeName());
            rowMap.put("\u4e2d\u5956\u5fae\u4fe1\u6635\u79f0", winner.getNickName());
            rowMap.put("\u4e2d\u5956\u5fae\u4fe1OpenId", winner.getWechatOpenId());
            rowMap.put("\u4e2d\u5956\u65f6\u95f4", DateUtil.getStrByDateFormate((Date)winner.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rowMap.put("\u767b\u8bb0\u65f6\u95f4", DateUtil.getStrByDateFormate((Date)winner.getCheckInTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rowMap.put("\u59d3\u540d", winner.getName());
            rowMap.put("\u624b\u673a\u53f7", winner.getMobile());
            rowMap.put("\u5730\u5740", winner.getAddress());
            rows.add(rowMap);
        }
        String subject = ConstantEnums.MAILBOX_DRAW_SUBJECT_WINNER.value();
        String content = ConstantEnums.MAILBOX_DRAW_CONTENT_WINNER.value();
        content = content.replace("{#ORG_NAME#}", orgName);
        this.sendMail(email, orgName, subject, content, activityId, rows);
        return TupleUtil.tuple(TupleUtil.OK, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
    }

    public void sendMail(final String email, String orgName, final String subject, final String content, final Long activityId, final List<Map<String, String>> rows) {
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File reportFile = null;
                try {
                    String password;
                    String username;
                    String host;
                    Mail mail;
                    block11: {
                        mail = new Mail();
                        String from = ConstantEnums.MAILBOX_FROM.value();
                        host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                        username = ConstantEnums.MAILBOX_USERNAME.value();
                        password = ConstantEnums.MAILBOX_PASSWORD.value();
                        mail.setFrom(from);
                        mail.setContent(content);
                        mail.addToAddress(email);
                        mail.setSubject(subject);
                        String filename = activityId + "_" + DateUtil.getStrByDate((Date)new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile != null) break block11;
                        return;
                    }
                    try {
                        DrawServiceImpl.this.logger.info("PARTAKE FILE  path is : {}", (Object)reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        DrawServiceImpl.this.logger.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    DrawServiceImpl.this.logger.info("send successful");
                }
                catch (Exception ex) {
                    DrawServiceImpl.this.logger.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }

    public DrawCacheDto getDrawCacheDtoFromDbById(long activityId) {
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(Long.valueOf(activityId), null);
        List prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(Long.valueOf(activityId));
        return DrawCacheDto.getInstance(drawInfo, prizeInfos);
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawResult draw(long activityId, String wechatOpenId) {
        this.logger.info("Start------------------1");
        DrawResult drawResult = new DrawResult();
        DrawCacheDto drawCacheDto = this.redisService.getDrawActivityBase(activityId);
        this.logger.info("Start------------------2");
        if (drawCacheDto == null) {
            this.logger.info("Start------------------3");
            drawCacheDto = this.getDrawCacheDtoFromDbById(activityId);
            this.logger.info("Start------------------4");
            this.redisService.setDrawActivityBase(activityId, drawCacheDto);
            this.logger.info("Start------------------5");
        }
        this.logger.info("Start------------------6");
        if (drawCacheDto == null) {
            drawResult.setCode(DrawCode.ERROR.getCode());
            return drawResult;
        }
        this.logger.info("[Draw] Cache Dto=" + ToStringBuilder.reflectionToString((Object)drawCacheDto));
        Fans fans = this.fansService.getFans(drawCacheDto.getOrgId().intValue(), wechatOpenId);
        if (fans == null || !fans.isSubscribed()) {
            CustomActivityDto wechatDto = this.customActivityService.getCustomActivity((int)activityId, 99);
            drawResult.setCode(DrawCode.UN_BIND.getCode());
            drawResult.setQrcodeUrl(wechatDto.getQrCodeUrl());
            return drawResult;
        }
        DrawCode drawCode = this.validate(drawCacheDto);
        if (drawCode != null) {
            drawResult.setCode(drawCode.getCode());
            return drawResult;
        }
        ActivityUser user = this.activityUserDao.selectActivityUser(wechatOpenId, DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"), activityId);
        if (user == null) {
            user = new ActivityUser();
            user.setActivityId(Long.valueOf(activityId));
            user.setCreateTime(new Date());
            user.setDoneCount(0);
            user.setDoneDate(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd"));
            user.setUpdateTime(new Date());
            user.setWechatOpenId(wechatOpenId);
        }
        if (user.getDoneCount() >= drawCacheDto.getLimitCount()) {
            drawResult.setCode(DrawCode.LIMIT_COUNT.getCode());
            return drawResult;
        }
        Date startTime = DateUtil.getStartOfDay((Date)new Date());
        Date endTime = DateUtil.getEndOfDay((Date)new Date());
        Map todayPrizeCount = this.winnerDao.selectPrizesByDate(activityId, startTime, endTime);
        int lucyDigit = this.luckyDraw(drawCacheDto.getBaseNum(), drawCacheDto.getProbabilities(), drawCacheDto.getPrizes(), todayPrizeCount);
        if (user.getId() == null) {
            user.setDoneCount(1);
            this.activityUserDao.insertActivityUser(user);
        } else {
            user.setDoneCount(user.getDoneCount() + 1);
            this.activityUserDao.updateActivityUserDoneCount(user);
        }
        if (lucyDigit > 0) {
            PrizeInfo[] prizes = drawCacheDto.getPrizes();
            this.logger.info("[Draw] grade=" + lucyDigit);
            PrizeInfo prize = prizes[lucyDigit - 1];
            if (prize.getWinNum() >= prize.getCountLimit()) {
                drawResult.setCode(DrawCode.UN_WIN.getCode());
                return drawResult;
            }
            Integer count = (Integer)todayPrizeCount.get(lucyDigit);
            if (count != null && count > prize.getNumber()) {
                drawResult.setCode(DrawCode.UN_WIN.getCode());
                return drawResult;
            }
            drawResult.setCode(DrawCode.SUCCESS.getCode());
            drawResult.setName(prize.getName());
            drawResult.setGrade(lucyDigit);
            Winner winner = new Winner();
            winner.setGrade(lucyDigit);
            winner.setPrizeName(prize.getName());
            winner.setActivityId(Long.valueOf(activityId));
            winner.setWechatOpenId(wechatOpenId);
            winner.setNickName(fans.getNick());
            this.winnerDao.insertWinner(winner);
            drawResult.setDrawId(winner.getDrawId());
            prize.setWinNum(Integer.valueOf(prize.getWinNum() + 1));
            int updateNum = this.prizeInfoDao.updateWinNum(prize.getId().longValue());
            if (updateNum != 1) {
                throw new BusinessException("\u5df2\u8d85\u51fa\u5956\u54c1\u603b\u6570\u91cf");
            }
        } else {
            drawResult.setCode(DrawCode.UN_WIN.getCode());
            return drawResult;
        }
        this.redisService.setDrawActivityBase(activityId, drawCacheDto);
        return drawResult;
    }

    private DrawCode validate(DrawCacheDto cacheDto) {
        Long currentTime = new Date().getTime();
        if (cacheDto == null) {
            this.logger.info("[Draw] Validate.activity is not exist.");
            return DrawCode.ERROR;
        }
        if (cacheDto.getStartTime() > currentTime) {
            return DrawCode.NOT_START;
        }
        if (cacheDto.getEndTime() <= currentTime) {
            return DrawCode.IS_END;
        }
        if (cacheDto.getStatus() == Status.CLOSED.getCode()) {
            return DrawCode.CLOSED;
        }
        return null;
    }

    private int luckyDraw(int base, int[] probabilities, PrizeInfo[] prizes, Map<Integer, Integer> todayPrizeCount) {
        for (int i = 0; i < prizes.length; ++i) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count == null || prizes[i].getNumber() > count && prizes[i].getWinNum() < prizes[i].getCountLimit()) continue;
            this.logger.info("[Draw] No prize =" + prizes[i].getGrade());
            base -= probabilities[i];
        }
        this.logger.info("[Draw] base=" + base);
        if (base <= 0) {
            return -1;
        }
        int digit = random.nextInt(base);
        int rank = 0;
        for (int i = 0; i < probabilities.length; ++i) {
            Integer count = todayPrizeCount.get(prizes[i].getGrade());
            if (count != null && (prizes[i].getNumber() <= count || prizes[i].getWinNum() >= prizes[i].getCountLimit()) || digit >= (rank += probabilities[i])) continue;
            return i + 1;
        }
        return -1;
    }
}

