/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sal.draw.dto.PrizeInfoDto;
import com.baijia.tianxiao.sal.draw.service.DrawPrizesService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DrawPrizesServiceImpl
implements DrawPrizesService {
    @Autowired
    private PrizeInfoDao prizeInfoDao;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void addPrizeInfo(List<PrizeInfo> prizeInfos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfos)) {
            return;
        }
        this.prizeInfoDao.batchAddPrizeInfos(prizeInfos);
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void addPrizes(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfoDtos)) {
            return;
        }
        List<PrizeInfo> prizeInfos = this.toPrizeInfos(activityId, prizeInfoDtos);
        this.prizeInfoDao.batchAddPrizeInfos(prizeInfos);
    }

    private List<PrizeInfo> toPrizeInfos(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfoDtos)) {
            return Collections.emptyList();
        }
        ArrayList<PrizeInfo> prizeInfos = new ArrayList<PrizeInfo>();
        for (PrizeInfoDto pid : prizeInfoDtos) {
            PrizeInfo buildPo = pid.buildPo();
            buildPo.setActivityId(activityId);
            prizeInfos.add(buildPo);
        }
        return prizeInfos;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void updatePrizes(Long activityId, List<PrizeInfo> prizeInfoDtos) {
        this.prizeInfoDao.deletePrizesByActivityId(activityId);
        this.addPrizeInfo(prizeInfoDtos);
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void updatePrizesByDtos(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        this.prizeInfoDao.deletePrizesByActivityId(activityId);
        this.addPrizes(activityId, prizeInfoDtos);
    }

    @Override
    public List<PrizeInfoDto> getPrizeInfoDtosByActivityId(Long activityId) {
        List prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(activityId);
        ArrayList<PrizeInfoDto> prizeInfoDtos = new ArrayList<PrizeInfoDto>();
        if (GenericsUtils.isNullOrEmpty((Object)prizeInfos)) {
            return Collections.emptyList();
        }
        for (PrizeInfo pi : prizeInfos) {
            PrizeInfoDto buildDto = PrizeInfoDto.buildDto(pi);
            prizeInfoDtos.add(buildDto);
        }
        return prizeInfoDtos;
    }

    @Override
    public List<PrizeInfo> getPrizeInfosByActivityId(Long activityId) {
        List prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(activityId);
        return prizeInfos;
    }

    @Override
    public PrizeInfo getPrizeById(Long drawId) {
        return this.prizeInfoDao.getPrizeInfosById(drawId);
    }
}

