/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.commons.utils;

import com.baijia.tianxiao.sal.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.commons.utils.Mail;
import com.baijia.tianxiao.sal.commons.utils.MailUtils;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    private static Logger logger = LoggerFactory.getLogger(CsvUtils.class);

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writerToCsvFile(File outputFile, CsvContent csvContent, String fileName) {
        if (!fileName.endsWith(".csv")) {
            fileName = fileName + ".csv";
        }
        File file = null;
        if (outputFile != null) {
            file = outputFile;
        } else {
            System.out.println(System.getProperty("java.io.tmpdir"));
            file = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName);
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("error : ", (Throwable)e);
                throw new RuntimeException("can not create new file with filepaht :" + file.getAbsolutePath());
            }
        }
        OutputStreamWriter outputWriter = null;
        try {
            byte[] bom = new byte[]{-17, -69, -65};
            FileOutputStream outputStream = new FileOutputStream(file);
            ((OutputStream)outputStream).write(bom);
            outputWriter = new OutputStreamWriter(outputStream);
            CsvWriterSettings settings = new CsvWriterSettings();
            settings.setNullValue("?");
            ((CsvFormat)settings.getFormat()).setComment('-');
            settings.setEmptyValue("!");
            settings.setSkipEmptyLines(false);
            CsvWriter writer = new CsvWriter((Writer)outputWriter, settings);
            List<RowBean> rowBeans = csvContent.getAllRows();
            if (rowBeans != null && rowBeans.size() > 0) {
                for (RowBean rowBean : rowBeans) {
                    if (rowBean.type == RowBean.rowType) {
                        String lineText = rowBean.getContent();
                        writer.writeRow(lineText);
                        continue;
                    }
                    if (rowBean.type != RowBean.tableType) continue;
                    String[] heads = rowBean.getHeads();
                    List<String> rows = rowBean.getRows();
                    writer.writeHeaders(heads);
                    for (int i = 0; i < rows.size(); ++i) {
                        writer.writeRow(rows.get(i));
                    }
                }
            }
            writer.close();
            IOUtils.closeQuietly((Writer)outputWriter);
        }
        catch (Exception ex) {
            logger.info("can not create csv file ,{}", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(outputWriter);
        }
        return file;
    }

    public static void main(String[] args) throws MessagingException, IOException {
        String[] heads;
        for (String head : heads = "\u59d3\u540d,\u7535\u8bdd,\u5176\u4ed6,\u62a5\u540d\u65f6\u95f4".split(",")) {
            System.out.println(head);
        }
        ArrayList<String> rows = new ArrayList<String>();
        rows.add("Rezar,18270826271,\u4f60\u597d\u5417-\u7537-\u767e\u5ea6-CEO,2015/12/12 12:12:12");
        rows.add("Rezar2,18270826271,\u4f60\u597d\u5417,2015/12/12 12:12:12");
        rows.add("Rezar3,18270826271,\u4f60\u597d\u5417,2015/12/12 12:12:12");
        rows.add("Rezar4,18270826271,\u4f60\u597d,2015/12/12 12:12:12");
        rows.add("Rezar5,18270826271,\u4f60\u597d\u5417,2015/12/12 12:12:12");
        CsvContent content = new CsvContent();
        content.addRowBean(RowBean.createRowType("\u6d3b\u52a8\u540d\u79f0:\u4e50\u5b66\u732b2016\u5bd2\u5047\u521d\u4e09\u51b2\u523a\u73ed"));
        content.addRowBean(RowBean.createTableType(heads, rows));
        File file = CsvUtils.writerToCsvFile(new File("/Users/bjhl/Desktop/test.csv"), content, "4444_20160912.csv");
        System.out.println(file.getAbsolutePath() + " : " + file.exists());
        Mail mail = new Mail();
        mail.setFrom("1916851825@qq.com");
        mail.setContent("\u8fd9\u662f\u6d4b\u8bd5\u4ee3\u7801");
        mail.addToAddress("yuwenhao@baijiahulian.com");
        AttachBean fileAttach = new AttachBean();
        fileAttach.setCid(file.getName());
        fileAttach.setFile(file);
        fileAttach.setFileName(file.getName());
        mail.addAttach(fileAttach);
        Session session = MailUtils.createSession("smtp.qq.com", "1916851825@qq.com", "YJ120707230");
        MailUtils.send(session, mail);
    }

    public static class RowBean {
        public static final Integer rowType = 1;
        public static final Integer tableType = 2;
        private Integer type;
        private String content;
        private String[] heads;
        private List<String> rows;

        public static RowBean createRowType(String rowText) {
            RowBean rb = new RowBean();
            rb.setType(1);
            rb.setContent(rowText);
            return rb;
        }

        public static RowBean createTableType(String[] heads, List<String> rows) {
            RowBean rb = new RowBean();
            rb.setType(tableType);
            rb.setHeads(heads);
            rb.setRows(rows);
            return rb;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String[] getHeads() {
            return this.heads;
        }

        public void setHeads(String[] heads) {
            this.heads = heads;
        }

        public List<String> getRows() {
            return this.rows;
        }

        public void setRows(List<String> rows) {
            this.rows = rows;
        }
    }

    public static class CsvContent {
        private List<RowBean> rowBeans = new ArrayList<RowBean>();

        public void addRowBean(RowBean rb) {
            this.rowBeans.add(rb);
        }

        public void deleteRowBean(RowBean rowBean) {
            this.rowBeans.remove(rowBean);
        }

        public List<RowBean> getAllRows() {
            return this.rowBeans;
        }
    }
}

