/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralRecordDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralBaseInfo;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralStatisticData;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferralStatisticsServiceImpl
implements ReferralStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(ReferralStatisticsServiceImpl.class);
    private static final int REFERRAL_ACTIVITY_CATEGORY = TemplateTypeCategory.REFERRAL_TYPE.getType();
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private ReferralRecordDao referralRecordDao;

    @Override
    public List<DairyCountStatistics> accessDairyCountStatistics(Long activityId, Long orgId, List<String> dateList) {
        boolean check = this.validateActivity(activityId, orgId);
        if (!check) {
            return Collections.emptyList();
        }
        ArrayList<DairyCountStatistics> retResult = new ArrayList<DairyCountStatistics>();
        ArrayList logs = this.activityAccessLogDao.selectActivityAccessLogByDate(dateList, activityId, REFERRAL_ACTIVITY_CATEGORY);
        if (GenericsUtils.isNullOrEmpty((Object)logs)) {
            logs = new ArrayList();
        }
        Map logMaps = CollectionUtils.extractMap(logs, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, ActivityAccessLog>(){

            public String extract(ActivityAccessLog arg0) {
                return arg0.getAccessDate();
            }
        });
        Integer count = 0;
        for (String date : dateList) {
            DairyCountStatistics dcs = new DairyCountStatistics();
            ActivityAccessLog log = (ActivityAccessLog)logMaps.get(date);
            if (log != null) {
                count = log.getAccessCount();
            }
            dcs.setCount(count.intValue());
            dcs.setDate(date);
            count = 0;
            retResult.add(dcs);
        }
        return retResult;
    }

    private boolean validateActivity(Long activityId, Long orgId) {
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, orgId);
        if (referralInfo == null) {
            log.info("can not find any activity with activityId:{} and orgId:{}", (Object)activityId, (Object)orgId);
            return false;
        }
        return true;
    }

    @Override
    public void setStatistics(List<ReferralBaseInfo> rbis) {
        if (GenericsUtils.isNullOrEmpty(rbis)) {
            return;
        }
        List activityIds = CollectionUtils.extractList(rbis, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, ReferralBaseInfo>(){

            public Long extract(ReferralBaseInfo arg0) {
                return arg0.getActivityId();
            }
        });
        Map accessLogs = this.activityAccessLogDao.selectTotalByActivityId(activityIds, REFERRAL_ACTIVITY_CATEGORY);
        Map customerCounts = this.referralRecordDao.listReferrals(activityIds);
        Map brokerCounts = this.referralRecordDao.listBrokerCount(activityIds);
        Map toPayAmounts = this.referralRecordDao.listToPayCount(activityIds);
        Iterator<ReferralBaseInfo> i$ = rbis.iterator();
        while (i$.hasNext()) {
            ReferralBaseInfo rbi;
            Long activityId = (rbi = i$.next()).getActivityId();
            Integer accessCount = (Integer)accessLogs.get(activityId);
            rbi.setBrowseCount(accessCount == null ? 0 : accessCount);
            Integer customerCount = (Integer)customerCounts.get(activityId);
            rbi.setCustomerNum(customerCount == null ? 0 : customerCount);
            Integer brokerCount = (Integer)brokerCounts.get(activityId);
            rbi.setBrokerNum(brokerCount == null ? 0 : brokerCount);
            Integer toPayAmount = (Integer)toPayAmounts.get(activityId);
            rbi.setToPayAmount(toPayAmount == null ? 0 : toPayAmount);
        }
        log.info("set statistics over :{}", rbis);
    }

    @Override
    public Map<Long, ReferralStatisticData> getPeriodReferralData(Date startTime, Date endTime, String curDate, List<Long> TianxiaoOrgIds) {
        log.info("param:{},{},{}", new Object[]{startTime, endTime, curDate});
        HashMap<Long, ReferralStatisticData> referralData = new HashMap<Long, ReferralStatisticData>();
        List orgIds = this.referralInfoDao.getExistOrgIds(TianxiaoOrgIds);
        if (GenericsUtils.isNullOrEmpty((Object)orgIds)) {
            return referralData;
        }
        Map activityIdsOfOrgIdByDay = this.referralInfoDao.getReferralActivityIdsByOrgIds(orgIds, startTime, endTime);
        log.info("Referral ActivityIds=" + activityIdsOfOrgIdByDay);
        Map activityIdsOfOrgId = this.referralInfoDao.getReferralActivityIdsByOrgIds(orgIds, null, null);
        for (Long orgId : orgIds) {
            ReferralStatisticData referralStatisticData = new ReferralStatisticData();
            Integer referralActivityTotal = 0;
            if (GenericsUtils.notNullAndEmpty(activityIdsOfOrgIdByDay.get(orgId))) {
                referralActivityTotal = ((List)activityIdsOfOrgIdByDay.get(orgId)).size();
            }
            List activityIds = (List)activityIdsOfOrgId.get(orgId);
            log.info("Referral ActivityIds=" + activityIds);
            Integer browseCount = 0;
            browseCount = StringUtils.isNotBlank((String)curDate) ? this.activityAccessLogDao.getActivityAccessLogTotalByDay(activityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()), curDate) : this.activityAccessLogDao.getActivityAccessLogTotal(activityIds, Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getType()));
            Integer brokerNum = this.referralRecordDao.getBrokerTotal(activityIds, startTime, endTime);
            Integer customerNum = this.referralRecordDao.getReferralTotal(activityIds, startTime, endTime);
            referralStatisticData.setReferralActivityTotal(referralActivityTotal == null ? 0 : referralActivityTotal);
            referralStatisticData.setBrowseCount(browseCount == null ? 0 : browseCount);
            referralStatisticData.setBrokerNum(brokerNum);
            referralStatisticData.setCustomerNum(customerNum == null ? 0 : customerNum);
            referralData.put(orgId, referralStatisticData);
        }
        return referralData;
    }
}

