/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.MarketingEntryDao;
import com.baijia.tianxiao.dal.activity.po.MarketingEntry;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MarketingEntryDto;
import com.baijia.tianxiao.sal.marketing.commons.service.MarketingEntryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingEntryServiceImpl
implements MarketingEntryService {
    private static final Logger log = LoggerFactory.getLogger(MarketingEntryServiceImpl.class);
    @Autowired
    private MarketingEntryDao entryDao;

    @Override
    public List<MarketingEntryDto> getAllMarketingEntry(boolean hasSmartPromote, String version) {
        ArrayList<MarketingEntryDto> dtoList = new ArrayList<MarketingEntryDto>();
        List entries = this.entryDao.selectAllMarketingEntries();
        LinkedHashMap<Integer, MarketingEntryDto> entryMap = new LinkedHashMap<Integer, MarketingEntryDto>();
        Collections.sort(entries, new Comparator<MarketingEntry>(){

            @Override
            public int compare(MarketingEntry o1, MarketingEntry o2) {
                if (o1.getGroupId() == o2.getGroupId()) {
                    return o1.getSortNum() - o2.getSortNum();
                }
                return o1.getGroupId() - o2.getGroupId();
            }
        });
        for (MarketingEntry entry : entries) {
            MarketingEntryDto dto;
            if (version.compareTo(String.valueOf(entry.getVersion())) < 0) continue;
            if (entry.getEvent().equals("tx_event_smartpromotion")) {
                if (!hasSmartPromote) continue;
                dto = MarketingEntryDto.createFromMarketingEntry(entry);
                entryMap.put(dto.getId(), dto);
                continue;
            }
            dto = MarketingEntryDto.createFromMarketingEntry(entry);
            entryMap.put(dto.getId(), dto);
        }
        Set keySet = entryMap.keySet();
        for (Integer key : keySet) {
            MarketingEntryDto dto = (MarketingEntryDto)((Object)entryMap.get(key));
            if (dto.getParentId() <= 0) {
                dtoList.add(dto);
                continue;
            }
            MarketingEntryDto parentEntry = (MarketingEntryDto)((Object)entryMap.get(dto.getParentId()));
            parentEntry.getSubEntries().add(dto);
        }
        return dtoList;
    }
}

