/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralBaseInfo;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class ReferralResponse
extends ReferralBaseInfo {
    private String orgName;
    private String orgLogo;
    private String orgQrCodeUrl;
    private String shareUrl;
    private String url;
    private List<GiftInfo> gifts;

    public static ReferralResponse buildResponse(ReferralInfo ri, List<GiftInfo> gifts) {
        ReferralResponse rr = new ReferralResponse();
        BeanUtils.copyProperties((Object)ri, (Object)rr, (String[])new String[]{"startTime", "endTime", "createTime", "updateTime"});
        rr.setUpdateTime(ri.getUpdateTime().getTime());
        rr.setCreateTime(ri.getCreateTime().getTime());
        rr.setStartTime(ri.getStartTime().getTime());
        rr.setEndTime(ri.getEndTime().getTime());
        String url = Config.DOMAIN + "/referral.html?activityId=" + ri.getActivityId();
        rr.setUrl(url + "#!/");
        rr.setShareUrl(url);
        rr.setGifts(gifts);
        ReferralBaseInfo.checkStatus(ri, rr);
        return rr;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getOrgLogo() {
        return this.orgLogo;
    }

    public String getOrgQrCodeUrl() {
        return this.orgQrCodeUrl;
    }

    public String getShareUrl() {
        return this.shareUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public List<GiftInfo> getGifts() {
        return this.gifts;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setOrgLogo(String orgLogo) {
        this.orgLogo = orgLogo;
    }

    public void setOrgQrCodeUrl(String orgQrCodeUrl) {
        this.orgQrCodeUrl = orgQrCodeUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setGifts(List<GiftInfo> gifts) {
        this.gifts = gifts;
    }

    @Override
    public String toString() {
        return "ReferralResponse(orgName=" + this.getOrgName() + ", orgLogo=" + this.getOrgLogo() + ", orgQrCodeUrl=" + this.getOrgQrCodeUrl() + ", shareUrl=" + this.getShareUrl() + ", url=" + this.getUrl() + ", gifts=" + this.getGifts() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferralResponse)) {
            return false;
        }
        ReferralResponse other = (ReferralResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$orgLogo = this.getOrgLogo();
        String other$orgLogo = other.getOrgLogo();
        if (this$orgLogo == null ? other$orgLogo != null : !this$orgLogo.equals(other$orgLogo)) {
            return false;
        }
        String this$orgQrCodeUrl = this.getOrgQrCodeUrl();
        String other$orgQrCodeUrl = other.getOrgQrCodeUrl();
        if (this$orgQrCodeUrl == null ? other$orgQrCodeUrl != null : !this$orgQrCodeUrl.equals(other$orgQrCodeUrl)) {
            return false;
        }
        String this$shareUrl = this.getShareUrl();
        String other$shareUrl = other.getShareUrl();
        if (this$shareUrl == null ? other$shareUrl != null : !this$shareUrl.equals(other$shareUrl)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<GiftInfo> this$gifts = this.getGifts();
        List<GiftInfo> other$gifts = other.getGifts();
        return !(this$gifts == null ? other$gifts != null : !((Object)this$gifts).equals(other$gifts));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReferralResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $orgLogo = this.getOrgLogo();
        result = result * 59 + ($orgLogo == null ? 43 : $orgLogo.hashCode());
        String $orgQrCodeUrl = this.getOrgQrCodeUrl();
        result = result * 59 + ($orgQrCodeUrl == null ? 43 : $orgQrCodeUrl.hashCode());
        String $shareUrl = this.getShareUrl();
        result = result * 59 + ($shareUrl == null ? 43 : $shareUrl.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<GiftInfo> $gifts = this.getGifts();
        result = result * 59 + ($gifts == null ? 43 : ((Object)$gifts).hashCode());
        return result;
    }
}

