/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.utils;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.upload.FileUploadUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtils.class);

    public static File download(String url) {
        if (GenericsUtils.isNullOrEmpty((Object)url)) {
            return null;
        }
        try {
            HttpClient client = new HttpClient();
            GetMethod httpGet = new GetMethod(url);
            client.executeMethod((HttpMethod)httpGet);
            File storeFile = new File(FileUtils.getTempDirectory(), Base64.encodeBase64String((byte[])url.getBytes()) + ".png");
            FileOutputStream output = new FileOutputStream(storeFile);
            output.write(httpGet.getResponseBody());
            output.close();
            return storeFile;
        }
        catch (Exception e) {
            log.error("error while download and upload image file : {} ,and will remember the  url :{}  in mongodb ", (Throwable)e);
            return null;
        }
    }

    public static String downloadAndUpload(String url) {
        try {
            File localFile = FileDownloadUtils.download(url);
            UploadResult upload = FileUploadUtils.upload(null, (File)localFile, (boolean)false);
            List files = upload.getFiles();
            if (GenericsUtils.notNullAndEmpty((Object)files)) {
                return Config.IMAGE_SERVER_HOST + ((UploadResult.UploadFile)files.get(0)).getUrl();
            }
        }
        catch (Exception e) {
            log.error("can not down or upload {}", (Throwable)e);
        }
        return "";
    }

    public static void main(String[] args) {
        String url = "http://mmbiz.qpic.cn/mmbiz/aSgMPQswpgKaRJPBoUXvW8WZXE8XNVxOibLSh7eFIiadsL90xUNkDBZkozsKDLeRq3PhSf5S9XuISpibtrQMvdyEA/0";
        System.out.println(FileDownloadUtils.downloadAndUpload(url));
    }
}

