/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.constants.TemplateSuffix;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityDetail;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityResponse;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawPrizesService;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DrawServiceImpl
implements DrawService {
    private static final Logger log = LoggerFactory.getLogger(DrawServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private DrawPrizesService drawPrizesService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private PrizeInfoDao prizeInfoDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private ActivityAccessLogDao accessLogDao;
    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private ActivityUserDao activityUserDao;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public DrawActivityDetail modifyActivity(DrawActivityRequest request) {
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(request.getActivityId(), request.getOrgId());
        if (drawInfo == null) {
            this.logger.warn("[Draw] Draw is not exist.activityId=" + request.getActivityId());
            return null;
        }
        TwoTuple<DrawInfo, List<PrizeInfo>> buildDetailPo = DrawActivityDetail.buildDetailPo(request);
        DrawInfo di = (DrawInfo)buildDetailPo.first;
        Long current = new Date().getTime();
        Timestamp currentTimestamp = new Timestamp(current);
        di.setUpdateTime(currentTimestamp);
        this.drawActivityDao.updateDrawActivity(di);
        List prizeInfos = (List)buildDetailPo.second;
        if (GenericsUtils.notNullAndEmpty((Object)prizeInfos)) {
            Long activityId = request.getActivityId();
            for (PrizeInfo pi : prizeInfos) {
                pi.setActivityId(activityId);
                if (!GenericsUtils.isNullOrEmpty((Object)pi.getUrl())) continue;
                String defaultImgUrl = ConstantEnums.findProperties(TemplateSuffix.getSuffixKey(TemplateTypeCategory.DRAW_TYPE, drawInfo.getTemplateId(), "DEFAULT_IMAGE"));
                pi.setUrl(defaultImgUrl);
            }
            this.drawPrizesService.updatePrizes(activityId, prizeInfos);
        }
        this.templateDao.updateTemplateUseCount(Long.valueOf(drawInfo.getTemplateId().longValue()));
        DrawCacheDto cacheDto = this.redisService.getDrawActivityBase(request.getActivityId());
        if (cacheDto != null) {
            this.redisService.setDrawActivityBase(request.getActivityId(), this.getDrawCacheDtoFromDbById(request.getActivityId()));
        }
        return this.getActivityDetail(request);
    }

    @Override
    public DrawActivityDetail getActivityDetail(DrawActivityRequest request) {
        Long activityId = request.getActivityId();
        DrawInfo di = this.drawActivityDao.getDrawInfoDetail(activityId, null, null);
        if (di == null) {
            return null;
        }
        List<PrizeInfo> prizeInfos = this.drawPrizesService.getPrizeInfosByActivityId(activityId);
        DrawActivityDetail detail = DrawActivityDetail.buildDetailDto(di, prizeInfos);
        this.setStatistical(Arrays.asList(detail));
        DrawActivityResponse dar = new DrawActivityResponse();
        try {
            BeanUtils.copyProperties((Object)dar, (Object)detail);
            dar.setPrizes(dar.getPrizeList());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("error : ", (Throwable)e);
        }
        String templateUrl = TemplateConstant.getTemplateUrl((Integer)di.getTemplateId());
        templateUrl = templateUrl.replaceAll("templateId=\\d+", "");
        String url = Config.DOMAIN + templateUrl + "activityId=" + activityId + "#!/";
        dar.setUrl(url);
        return dar;
    }

    private void setStatistical(List<? extends DrawActivityBase> baseInfos) {
        if (baseInfos == null) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(baseInfos.size());
        for (DrawActivityBase drawActivityBase : baseInfos) {
            list.add(drawActivityBase.getActivityId());
        }
        Map accessMap = this.accessLogDao.selectTotalByActivityId(list, TemplateTypeCategory.DRAW_TYPE.getType());
        Map map = this.activityUserDao.selectTotalByActivityIdAndCategory(list, Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getType()));
        Map winnerMap = this.winnerDao.selectTotalByActivityId(list);
        for (DrawActivityBase drawActivityBase : baseInfos) {
            Integer browseCount = (Integer)accessMap.get(drawActivityBase.getActivityId());
            Integer userCount = (Integer)map.get(drawActivityBase.getActivityId());
            Integer winnerCount = (Integer)winnerMap.get(drawActivityBase.getActivityId());
            drawActivityBase.setBrowseCount(browseCount == null ? 0 : browseCount);
            drawActivityBase.setUserCount(userCount == null ? 0 : userCount);
            drawActivityBase.setWinnerCount(winnerCount == null ? 0 : winnerCount);
        }
    }

    @Override
    public List<DrawActivityBase> getActivityList(DrawActivityRequest request) {
        List listDrawActivity = this.drawActivityDao.listDrawActivity(request.getStatus(), request.getLastId(), request.getOrgId(), request.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)listDrawActivity)) {
            return Collections.emptyList();
        }
        ArrayList<DrawActivityBase> baseInfos = new ArrayList<DrawActivityBase>(listDrawActivity.size());
        for (DrawInfo di : listDrawActivity) {
            DrawActivityBase baseInfo = new DrawActivityBase().buildDto(di);
            baseInfos.add(baseInfo);
        }
        this.setStatistical(baseInfos);
        return baseInfos;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public boolean modifyStatus(DrawActivityRequest request) {
        DrawInfo di = request.buildPo();
        this.logger.info("[ModifyStatus]" + di.getStatus());
        try {
            di.setUpdateTime(new Timestamp(new Date().getTime()));
            this.drawActivityDao.updateDrawActivity(di);
            DrawCacheDto cacheDto = this.redisService.getDrawActivityBase(request.getActivityId());
            if (cacheDto != null) {
                cacheDto.setStatus(request.getStatus());
                this.logger.info("[ModifyStatus] Cache=" + request.getStatus());
                this.redisService.setDrawActivityBase(request.getActivityId(), cacheDto);
            }
            return true;
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return false;
        }
    }

    @Override
    public DrawCacheDto getDrawCacheDtoFromDbById(long activityId) {
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(Long.valueOf(activityId), null);
        List prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(Long.valueOf(activityId));
        return DrawCacheDto.getInstance(drawInfo, prizeInfos);
    }
}

