/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.enums;

import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SystemType {
    TX_MARKETING(1, Config.DOMAIN),
    CW_MARKETING(2, Config.CAIWU_DOMAIN),
    TX_CRM(3, Config.CRM_DOMAIN),
    YINGXIAO(4, Config.YINGXIAO);

    private static final Logger log;
    public int type;
    public String domain;

    private SystemType(Integer type, String domain) {
        this.type = type;
        this.domain = domain;
    }

    public int getType() {
        return this.type;
    }

    public String getDomain() {
        return this.domain;
    }

    public static String getDomain(int type) {
        for (SystemType systemType : SystemType.values()) {
            if (systemType.getType() != type) continue;
            log.info("[Config] Domain=" + systemType.getDomain() + ";type=" + type);
            return systemType.getDomain();
        }
        return "";
    }

    static {
        log = LoggerFactory.getLogger(SystemType.class);
    }
}

