/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.service.impl;

import com.baijia.tianxiao.dal.activity.dao.article.ArticleBaseInfoDao;
import com.baijia.tianxiao.dal.activity.po.ArticleBaseInfo;
import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.sal.marketing.activity.dto.ShareDto;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleTypeDto;
import com.baijia.tianxiao.sal.marketing.article.dto.HotArticleDto;
import com.baijia.tianxiao.sal.marketing.article.enums.ArticleTypes;
import com.baijia.tianxiao.sal.marketing.article.service.ArticleService;
import com.baijia.tianxiao.sal.marketing.article.service.ImageFileService;
import com.baijia.tianxiao.sal.marketing.article.utils.ArticleUtil;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
implements ArticleService {
    private static final Logger log = LoggerFactory.getLogger(ArticleServiceImpl.class);
    @Autowired(required=false)
    private ArticleBaseInfoDao articleBaseInfoDao;
    @Autowired
    private ImageFileService imageFileService;

    @Override
    public List<HotArticleDto> getHotArticleFromMongo(int type, PageDto pageDto) {
        List listArticles = this.articleBaseInfoDao.findArticleBaseInfoListByPage(type, pageDto);
        if (GenericsUtils.isNullOrEmpty((Object)listArticles)) {
            return Collections.emptyList();
        }
        this.uploadWeixinImgToLocalServer(listArticles);
        ArrayList<HotArticleDto> articleDtos = new ArrayList<HotArticleDto>(listArticles.size());
        for (ArticleBaseInfo articleInfo : listArticles) {
            HotArticleDto had = HotArticleDto.getFromArticleBaseInfo(articleInfo);
            articleDtos.add(had);
        }
        return articleDtos;
    }

    private void uploadWeixinImgToLocalServer(List<ArticleBaseInfo> listArticles) {
        List srcs = ListUtil.toKeyList(listArticles, (String)"articleImg", ArticleBaseInfo.class);
        ArrayList<String> needUpload = new ArrayList<String>();
        for (String src : srcs) {
            if (src.startsWith(Config.IMAGE_SERVER_HOST)) continue;
            needUpload.add(src);
        }
        Map<String, String> downloadAndUploadManys = this.imageFileService.downloadAndUploadManys(needUpload);
        for (ArticleBaseInfo abi : listArticles) {
            String oldUrl = abi.getArticleImg();
            if (!needUpload.contains(oldUrl)) continue;
            String newUrl = downloadAndUploadManys.get(oldUrl);
            abi.setArticleImg(newUrl);
            this.articleBaseInfoDao.updateArticle(abi);
        }
    }

    @Override
    public List<ArticleTypeDto> getArticleTypes() {
        ArticleTypes[] types = ArticleTypes.values();
        ArrayList<ArticleTypeDto> list = new ArrayList<ArticleTypeDto>();
        for (ArticleTypes type : types) {
            list.add(ArticleTypeDto.getArticleTypeDto(type));
        }
        return list;
    }

    @Override
    public ShareDto getShareDto(String articleId, OrgInfoSimpleDto orgInfoSimpleDto) {
        ShareDto shareDto = new ShareDto();
        ArticleDetail articleInfo = this.articleBaseInfoDao.findArticleDetailById(articleId);
        if (articleInfo == null) {
            return shareDto;
        }
        Long orgNumber = orgInfoSimpleDto.getOrgNumber();
        String digest = ArticleUtil.getDigest(articleInfo.getAbstractContent());
        if (StringUtils.isBlank((String)digest)) {
            digest = ArticleUtil.getDigest(articleInfo.getContent());
        }
        shareDto.setContent(digest);
        shareDto.setImageUrl(articleInfo.getArticleImg() + "@1e_100w_100h_1c.jpg");
        shareDto.setShareUrl(Config.DOMAIN + "/article.html?articleId=" + articleId + "&orgNumber=" + orgNumber);
        shareDto.setTitle(articleInfo.getArticleTitle());
        return shareDto;
    }
}

