/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl.mq;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsDto;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class MqServiceImpl
implements MqService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MqServiceImpl.class);
    private CloudQueue consultMsgQueue;

    @Override
    public void pushMns(MnsDto msg, String prefix) {
        try {
            JSONObject json = JSONObject.fromObject((Object)msg);
            this.consultMsgQueue.putMessage(new Message(prefix + json.toString()));
            log.info("put message to activityMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            log.info("put message to activityMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("activity.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error. e:{}", (Throwable)e);
        }
    }
}

