/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.utils;

import com.baijia.tianxiao.util.GenericsUtils;

public class JsonFormatUtil {
    public static void printJson(String jsonStr) {
        System.out.println(JsonFormatUtil.formatJson(jsonStr));
    }

    public static String formatJson(String jsonStr) {
        if (GenericsUtils.isNullOrEmpty((Object)jsonStr) || jsonStr.length() >= 500) {
            return jsonStr;
        }
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, ++indent);
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block5;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block5;
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, indent);
                    continue block5;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }
}

