/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public class RecordRespDto
extends SmsGroupSendResp {
    public static final int limit = Integer.parseInt(GenericsUtils.isNullOrEmpty((Object)Config.LOCAL_BATCH_SEND_COUNT_LIMIT) ? "100" : Config.LOCAL_BATCH_SEND_COUNT_LIMIT);
    public static final int system_limit = Integer.parseInt(GenericsUtils.isNullOrEmpty((Object)Config.SYSTEM_BATCH_SEND_COUNT_LIMIT) ? "1000" : Config.SYSTEM_BATCH_SEND_COUNT_LIMIT);
    private Long recordId;
    private int sendStatus;
    private int leftSmsCount;
    private int localBatchSendCount;
    @JsonIgnore
    private Integer code = SendStatus.SEND_OK.getCode();

    public static RecordRespDto buildDto(Long id, List<StudentDto> studentDtos) {
        RecordRespDto resp = new RecordRespDto();
        resp.setRecordId(id);
        resp.setTotalStuCount(studentDtos.size());
        return resp;
    }

    public static RecordRespDto buildDto(Long recordId, int totalStuCount, int leftSmsCount, int sendStatus, Integer respCode) {
        RecordRespDto resp = new RecordRespDto();
        resp.setRecordId(recordId);
        resp.setTotalStuCount(totalStuCount);
        if (leftSmsCount <= 0) {
            leftSmsCount = 0;
        }
        resp.setLeftSmsCount(leftSmsCount);
        resp.setLocalBatchSendCount(limit);
        resp.setSendStatus(sendStatus);
        if (respCode != null) {
            resp.setCode(respCode);
        }
        return resp;
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public int getSendStatus() {
        return this.sendStatus;
    }

    public int getLeftSmsCount() {
        return this.leftSmsCount;
    }

    public int getLocalBatchSendCount() {
        return this.localBatchSendCount;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public void setSendStatus(int sendStatus) {
        this.sendStatus = sendStatus;
    }

    public void setLeftSmsCount(int leftSmsCount) {
        this.leftSmsCount = leftSmsCount;
    }

    public void setLocalBatchSendCount(int localBatchSendCount) {
        this.localBatchSendCount = localBatchSendCount;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "RecordRespDto(recordId=" + this.getRecordId() + ", sendStatus=" + this.getSendStatus() + ", leftSmsCount=" + this.getLeftSmsCount() + ", localBatchSendCount=" + this.getLocalBatchSendCount() + ", code=" + this.getCode() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordRespDto)) {
            return false;
        }
        RecordRespDto other = (RecordRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recordId = this.getRecordId();
        Long other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
            return false;
        }
        if (this.getSendStatus() != other.getSendStatus()) {
            return false;
        }
        if (this.getLeftSmsCount() != other.getLeftSmsCount()) {
            return false;
        }
        if (this.getLocalBatchSendCount() != other.getLocalBatchSendCount()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        return !(this$code == null ? other$code != null : !((Object)this$code).equals(other$code));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RecordRespDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
        result = result * 59 + this.getSendStatus();
        result = result * 59 + this.getLeftSmsCount();
        result = result * 59 + this.getLocalBatchSendCount();
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        return result;
    }
}

