/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelHelper;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Session;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelMailSender {
    private static final Logger log = LoggerFactory.getLogger(ExcelMailSender.class);

    public static void sendMail(final String email, final String subject, final String content, final File[] files) {
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    try {
                        Mail mail = new Mail();
                        String from = ConstantEnums.TIANXIAO_MAILBOX_FROM.value();
                        String host = ConstantEnums.TIANXIAO_MAILBOX_SMTPSERVIER.value();
                        String username = ConstantEnums.TIANXIAO_MAILBOX_USERNAME.value();
                        String password = ConstantEnums.TIANXIAO_MAILBOX_PASSWORD.value();
                        mail.setFrom(from);
                        mail.setContent(content);
                        mail.addToAddress(email);
                        mail.setSubject(subject);
                        log.info("mail is : " + ToStringBuilder.reflectionToString((Object)mail));
                        if (GenericsUtils.notNullAndEmpty((Object)files)) {
                            try {
                                for (File file : files) {
                                    if (!file.exists()) continue;
                                    AttachBean fileAttach = new AttachBean();
                                    fileAttach.setCid(file.getName());
                                    fileAttach.setFile(file);
                                    fileAttach.setFileName(file.getName());
                                    mail.addAttach(fileAttach);
                                }
                            }
                            catch (Exception e) {
                                log.error("error :", (Throwable)e);
                            }
                        }
                        Session session = null;
                        session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                        MailUtils.send(session, mail);
                        log.info("send successful");
                        System.out.println("send successful");
                    }
                    catch (Exception ex) {
                        log.error("can not send email cause by {}", (Throwable)ex);
                    }
                    finally {
                        if (!GenericsUtils.notNullAndEmpty((Object)files)) break block10;
                        for (File file : files) {
                            if (file == null) continue;
                            file.delete();
                        }
                    }
                }
            }
        });
    }

    public static void sendMail(final String email, final String subject, final String content, final String fileName, final List<Map<String, String>> rows) {
        log.info("begin to send mail ");
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File reportFile = null;
                try {
                    String password;
                    String username;
                    String host;
                    Mail mail;
                    block11: {
                        System.out.println("begin to send mail !");
                        mail = new Mail();
                        String from = ConstantEnums.MAILBOX_FROM.value();
                        host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                        username = ConstantEnums.MAILBOX_USERNAME.value();
                        password = ConstantEnums.MAILBOX_PASSWORD.value();
                        mail.setFrom(from);
                        mail.setContent(content);
                        mail.addToAddress(email);
                        mail.setSubject(subject);
                        String filename = fileName + "_" + DateUtil.getStrByDate((Date)new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile != null) break block11;
                        return;
                    }
                    try {
                        log.info("PARTAKE FILE  path is : {}", (Object)reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        log.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }
}

