/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.util.GenericsUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper<T> {
    public static final String OFFICE_EXCEL_2003_POSTFIX = "xls";
    public static final String OFFICE_EXCEL_2010_POSTFIX = "xlsx";
    public static final String EMPTY = "";
    public static final String POINT = ".";
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Logger logger = Logger.getLogger(ExcelHelper.class);
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    public void exportToExcel(HttpServletRequest request, HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue) {
        this.exportToExcel(request, response, data, fields, fieldValue, null);
    }

    public void exportToExcel(HttpServletRequest request, HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue, String fileName) {
        int i;
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < fields.length; ++i) {
            Cell cell = headerTitle.createCell(index++ % fields.length);
            cell.setCellValue(fieldValue[i]);
        }
        for (i = 0; i < data.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            T o = data.get(i);
            for (int j = 0; j < fields.length; ++j) {
                Cell cell = row.createCell(index++ % fields.length);
                try {
                    cell.setCellValue(BeanUtils.getProperty(o, (String)fields[j]));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
        }
        if (fileName == null || EMPTY.equals(fileName)) {
            fileName = System.currentTimeMillis() + ".xls";
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        try {
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File exportToExcelLocalFileFromMap(List<Map<String, String>> source, String file) {
        File localFile;
        block15: {
            int i;
            if (GenericsUtils.isNullOrEmpty(source)) {
                return null;
            }
            System.out.println(source.size());
            Set<String> headSets = source.get(0).keySet();
            String[] fieldValue = new String[headSets.size()];
            headSets.toArray(fieldValue);
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet sheet = wb.createSheet("ExportDataList");
            Row headerTitle = sheet.createRow(0);
            int index = 0;
            for (i = 0; i < fieldValue.length; ++i) {
                Cell cell = headerTitle.createCell(index++ % fieldValue.length);
                cell.setCellValue(fieldValue[i]);
            }
            i = 0;
            for (Map<String, String> data : source) {
                Row row = sheet.createRow(i + 1);
                for (int j = 0; j < fieldValue.length; ++j) {
                    Cell cell = row.createCell(index++ % fieldValue.length);
                    try {
                        String key = fieldValue[j].toString();
                        cell.setCellValue(data.get(key));
                        continue;
                    }
                    catch (Exception e) {
                        logger.info((Object)("[fieldValue]" + fieldValue[j]));
                    }
                }
                ++i;
            }
            if (file == null || EMPTY.equals(file)) {
                file = System.currentTimeMillis() + ".xls";
            }
            System.out.println(file);
            localFile = new File(file);
            if (!localFile.exists()) {
                try {
                    localFile.createNewFile();
                }
                catch (IOException e) {
                    logger.info((Object)e);
                    return null;
                }
            }
            FileOutputStream out = null;
            BufferedOutputStream bos = null;
            try {
                out = new FileOutputStream(localFile);
                bos = new BufferedOutputStream(out);
                wb.write((OutputStream)bos);
                wb = null;
                IOUtils.closeQuietly((OutputStream)bos);
            }
            catch (Exception e) {
                logger.info((Object)"[ writer file failure : ]", (Throwable)e);
                break block15;
            }
            finally {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)out);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToExcelLocalFile(List<T> data, String[] fields, String[] fieldValue, String file) {
        block12: {
            int i;
            if (fields == null || fieldValue == null) {
                throw new RuntimeException("fields or header can't be null.");
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet sheet = wb.createSheet("ExportDataList");
            Row headerTitle = sheet.createRow(0);
            int index = 0;
            for (i = 0; i < fields.length; ++i) {
                Cell cell = headerTitle.createCell(index++ % fields.length);
                cell.setCellValue(fieldValue[i]);
            }
            for (i = 0; i < data.size(); ++i) {
                Row row = sheet.createRow(i + 1);
                T o = data.get(i);
                for (int j = 0; j < fields.length; ++j) {
                    Cell cell = row.createCell(index++ % fields.length);
                    try {
                        cell.setCellValue(BeanUtils.getProperty(o, (String)fields[j]));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("export data error", e);
                    }
                }
            }
            if (file == null || EMPTY.equals(file)) {
                file = System.currentTimeMillis() + ".xls";
            }
            File localFile = new File(file);
            FileOutputStream out = null;
            BufferedOutputStream bos = null;
            try {
                out = new FileOutputStream(localFile);
                bos = new BufferedOutputStream(out);
                wb.write((OutputStream)bos);
                wb = null;
                IOUtils.closeQuietly((OutputStream)bos);
            }
            catch (Exception e) {
                logger.info((Object)"[ writer file failure : ]", (Throwable)e);
                break block12;
            }
            finally {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)out);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static List<Map<Integer, String>> readExcel(InputStream is, String fileName) throws Exception {
        String postfix = ExcelHelper.getPostfix(fileName);
        if (OFFICE_EXCEL_2003_POSTFIX.equals(postfix)) {
            return ExcelHelper.readXls(is);
        }
        if (OFFICE_EXCEL_2010_POSTFIX.equals(postfix)) {
            return ExcelHelper.readXlsx(is);
        }
        return null;
    }

    public static List<Map<Integer, String>> readXlsx(InputStream is) throws IOException {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(is);
        ArrayList<Map<Integer, String>> list = new ArrayList<Map<Integer, String>>();
        for (int numSheet = 0; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
            if (xssfSheet == null) continue;
            for (int rowNum = xssfSheet.getFirstRowNum(); rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                int firstCellNum = xssfRow.getFirstCellNum();
                short lastCellNum = xssfRow.getLastCellNum();
                for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                    map.put(cellNum, ExcelHelper.getValue(xssfRow.getCell(cellNum)));
                }
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<Integer, String>> readXls(InputStream is) throws IOException {
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
        ArrayList<Map<Integer, String>> list = new ArrayList<Map<Integer, String>>();
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;
            for (int rowNum = hssfSheet.getFirstRowNum(); rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                if (hssfRow == null) continue;
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                int firstCellNum = hssfRow.getFirstCellNum();
                short lastCellNum = hssfRow.getLastCellNum();
                for (int cellNum = firstCellNum; cellNum < lastCellNum && null != hssfRow.getCell(firstCellNum); ++cellNum) {
                    map.put(cellNum, ExcelHelper.getValue(hssfRow.getCell(cellNum)));
                }
                list.add(map);
            }
        }
        return list;
    }

    public static String getCellStringValue(Cell cell) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 0) {
            return nf.format(cell.getNumericCellValue());
        }
        return cell.getStringCellValue();
    }

    private static String getValue(XSSFCell xssfRow) {
        DecimalFormat df = new DecimalFormat("0");
        if (xssfRow.getCellType() == 4) {
            return String.valueOf(xssfRow.getBooleanCellValue());
        }
        if (xssfRow.getCellType() == 0) {
            return String.valueOf(df.format(xssfRow.getNumericCellValue()));
        }
        return String.valueOf(xssfRow.getStringCellValue());
    }

    private static String getValue(HSSFCell hssfCell) {
        DecimalFormat df = new DecimalFormat("0");
        if (hssfCell.getCellType() == 4) {
            return String.valueOf(hssfCell.getBooleanCellValue());
        }
        if (hssfCell.getCellType() == 0) {
            return String.valueOf(df.format(hssfCell.getNumericCellValue()));
        }
        if (hssfCell.getCellType() == 2) {
            return String.valueOf(hssfCell.getCellFormula());
        }
        return String.valueOf(hssfCell.getStringCellValue());
    }

    private static String getPostfix(String path) {
        if (path == null || EMPTY.equals(path.trim())) {
            return EMPTY;
        }
        if (path.contains(POINT)) {
            return path.substring(path.lastIndexOf(POINT) + 1, path.length());
        }
        return EMPTY;
    }

    public static <T> void exportToExcel(HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue) {
        ExcelHelper.exportToExcel(response, data, fields, fieldValue, null);
    }

    public static <T> void exportToExcel(HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue, String fileName) {
        if (fileName == null || EMPTY.equals(fileName)) {
            fileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        }
        try {
            ExcelHelper.exportToExcel((OutputStream)response.getOutputStream(), data, fields, fieldValue);
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public static <T> void exportToExcel(OutputStream os, List<T> data, String[] fields, String[] fieldValue) {
        int i;
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < fields.length; ++i) {
            Cell cell = headerTitle.createCell(index++ % fields.length);
            cell.setCellValue(fieldValue[i]);
            sheet.setColumnWidth(cell.getColumnIndex(), fieldValue[i].length() * 8 * 256);
            cell.getCellStyle().setAlignment((short)2);
        }
        try {
            for (i = 0; i < data.size(); ++i) {
                Row row = sheet.createRow(i + 1);
                T o = data.get(i);
                for (int j = 0; j < fields.length; ++j) {
                    try {
                        ExcelHelper.createCell(sheet, row, index++ % fields.length, propertyUtilsBean.getProperty(o, fields[j]));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("export data error", e);
                    }
                }
            }
            wb.write(os);
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public static <T> ZipOutputStream getZipOutputStream(HttpServletResponse response, String fileName) throws IOException {
        if (fileName == null || EMPTY.equals(fileName)) {
            fileName = System.currentTimeMillis() + ".zip";
        }
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
        ConvertUtils.register((Converter)new DateLocaleConverter(Locale.CHINA), Date.class);
        ZipOutputStream out = new ZipOutputStream((OutputStream)response.getOutputStream());
        return out;
    }

    public static <T> void exportToZip(ZipOutputStream out, List<T> data, String[] fields, String[] fieldValue, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ExcelHelper.exportToExcel((OutputStream)baos, data, fields, fieldValue);
            out.putNextEntry(new ZipEntry("./tts_export/" + fileName + ".xlsx"));
            out.write(baos.toByteArray());
            out.flush();
            out.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public static <T> void closeZipOutputStream(ZipOutputStream out) {
        if (out != null) {
            try {
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void createCell(Sheet sheet, Row row, int column, Object value) {
        Cell cell = row.createCell(column);
        if (value != null) {
            DataFormat format = sheet.getWorkbook().createDataFormat();
            CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
            cellStyle.setAlignment((short)2);
            if (value instanceof Date) {
                sheet.setColumnWidth(cell.getColumnIndex(), 5120);
                cellStyle.setDataFormat(format.getFormat(EXPORT_DATE_FORMAT));
                cell.setCellStyle(cellStyle);
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                cell.setCellType(0);
                if (value instanceof Double) {
                    cellStyle.setDataFormat(format.getFormat("0.00"));
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    cellStyle.setDataFormat(format.getFormat("0"));
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellType(1);
                cell.setCellValue(value.toString());
                cellStyle.setDataFormat(format.getFormat("@"));
            }
            cell.setCellStyle(cellStyle);
        } else {
            cell.setCellValue(EMPTY);
        }
    }
}

