/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtils {
    private static Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    public static final Type[] getGenericTypes(Class<?> c) {
        Type superClass = c.getGenericSuperclass();
        ParameterizedType type = (ParameterizedType)superClass;
        return type.getActualTypeArguments();
    }

    public static Set<Field> getAllFiled(Class<?> entityClass) {
        HashSet<Field> fs = new HashSet<Field>();
        for (Field f : entityClass.getFields()) {
            fs.add(f);
        }
        for (Field f : entityClass.getDeclaredFields()) {
            fs.add(f);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!superClass.equals(Object.class)) {
            Set<Field> superFileds = ClassUtils.getAllFiled(superClass);
            fs.addAll(superFileds);
        }
        return fs;
    }

    public static Set<Method> getAllMethod(Class<?> entityClass) {
        HashSet<Method> ms = new HashSet<Method>();
        for (Method m : entityClass.getMethods()) {
            ms.add(m);
        }
        for (Method m : entityClass.getDeclaredMethods()) {
            ms.add(m);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!superClass.equals(Object.class)) {
            Set<Method> superFileds = ClassUtils.getAllMethod(superClass);
            ms.addAll(superFileds);
        }
        return ms;
    }

    public static final void copyProperties(Object from, Object to) {
        Set<Field> fromSet = ClassUtils.getAllFiled(from.getClass());
        Set<Field> toSet = ClassUtils.getAllFiled(to.getClass());
        HashMap<String, Field> toMap = new HashMap<String, Field>();
        for (Field f : toSet) {
            toMap.put(f.getName(), f);
        }
        for (Field f : fromSet) {
            String name;
            Field toField;
            if (Modifier.isStatic(f.getModifiers()) || (toField = (Field)toMap.get(name = f.getName())) == null) continue;
            toField.setAccessible(true);
            f.setAccessible(true);
            try {
                toField.set(to, f.get(from));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Field getFieldFromClass(String field, Class<? extends Object> clazz) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (Exception e) {
            try {
                return clazz.getField(field);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static boolean fieldIsEffectAndCache(Field field, String cacheKey) {
        if (field != null) {
            fieldCache.put(cacheKey, field);
            return true;
        }
        return false;
    }

    public static Field getCachedFieldFromClass(String field, Class<?> clazz) {
        String cacheKey = clazz + "|" + field;
        Field result = fieldCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        try {
            result = clazz.getDeclaredField(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ClassUtils.fieldIsEffectAndCache(result, cacheKey)) {
            return result;
        }
        try {
            result = clazz.getField(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ClassUtils.fieldIsEffectAndCache(result, cacheKey)) {
            return result;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return null;
        }
        result = ClassUtils.getCachedFieldFromClass(field, superClass);
        if (ClassUtils.fieldIsEffectAndCache(result, cacheKey)) {
            return result;
        }
        return null;
    }
}

