/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.thread;

import com.baijia.tianxiao.task.local.exception.TaskTimeoutException;
import com.baijia.tianxiao.task.local.task.thread.TaskManager;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkUnit {
    private static final Log LOG = LogFactory.getLog(TaskManager.class);
    private CompletionService<Object> completion;
    private Map<Future<?>, Runnable> futureMap = new ConcurrentHashMap();
    private int taskCount;
    private Thread parentThread = Thread.currentThread();
    private volatile boolean isWaitOver = false;

    public WorkUnit(Executor pool) {
        this.completion = new ExecutorCompletionService<Object>(pool);
    }

    public void submit(Runnable runnable) {
        this.futureMap.put(this.completion.submit(runnable, null), runnable);
        ++this.taskCount;
    }

    public void submitForTaskFuture(Runnable runnable) {
        this.completion.submit(runnable, null);
    }

    public void waitForCompletion() {
        this.waitForCompletion(TaskManager.config().taskTimeoutMillSeconds());
    }

    public void waitForCompletion(long timeoutMillSeconds) {
        if (this.isWaitOver) {
            return;
        }
        for (int i = 0; i < this.taskCount; ++i) {
            Future<Object> future;
            try {
                long timeout = timeoutMillSeconds > 0L ? timeoutMillSeconds : TaskManager.config().taskTimeoutMillSeconds();
                future = this.completion.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("wait for execute completion failed,e=" + e), (Throwable)e);
                throw new TaskTimeoutException(e);
            }
            if (future == null) {
                this.cancelAllTask();
                String errMsg = "wait for execute completion timeout: ";
                LOG.error((Object)(errMsg + this.futureInfo()));
                this.cleanResource();
                throw new TaskTimeoutException(errMsg);
            }
            this.futureMap.remove(future);
        }
        this.isWaitOver = true;
        this.cleanResource();
    }

    private void cancelAllTask() {
        for (Future<?> future : this.futureMap.keySet()) {
            boolean isCancel = future.cancel(true);
            LOG.info((Object)("cancel task success: " + isCancel + ": " + this.futureMap.get(future)));
        }
    }

    private String futureInfo() {
        StringBuilder sb = new StringBuilder();
        for (Runnable task : this.futureMap.values()) {
            sb.append(task.toString());
        }
        return sb.toString();
    }

    private void cleanResource() {
        this.futureMap = null;
        this.completion = null;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }
}

