/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.thread;

import com.baijia.tianxiao.task.local.common.TaskPair;
import com.baijia.tianxiao.task.local.spring.integration.TaskBeanContainer;
import com.baijia.tianxiao.task.local.task.Taskable;
import com.baijia.tianxiao.task.local.task.thread.SimpleTaskFutrue;
import com.baijia.tianxiao.task.local.task.thread.TaskContext;
import com.baijia.tianxiao.task.local.utils.ArrayUtils;
import com.baijia.tianxiao.task.local.utils.AssistUtils;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TaskWrapper
implements Runnable {
    private Taskable<?> fetcher;
    private String fetcherName;
    private Object args;
    private TaskContext context;
    private SimpleTaskFutrue tf;

    public <T> TaskWrapper(Taskable<?> fetcher, Object args, TaskContext context) {
        this.fetcher = fetcher;
        this.args = args;
    }

    public <T> TaskWrapper(Taskable<?> fetcher, Object args, TaskContext context, String fetcherName) {
        this.fetcher = fetcher;
        this.args = args;
        this.context = context;
        this.fetcherName = fetcherName;
        this.tf = new SimpleTaskFutrue();
        this.context.putResult(this.fetcherName, this.tf);
    }

    public static List<TaskWrapper> wrapperFetcher(TaskBeanContainer container, TaskContext context, TaskPair ... queryPairs) {
        ArrayList<TaskWrapper> fetchers = new ArrayList<TaskWrapper>();
        if (ArrayUtils.isArrayEmpty(queryPairs)) {
            return fetchers;
        }
        for (TaskPair qp : queryPairs) {
            Taskable<?> fetcher = container.task(AssistUtils.removeTaskVersion((String)qp.field1));
            fetchers.add(new TaskWrapper(fetcher, qp.field2, context, (String)qp.field1));
        }
        return fetchers;
    }

    public void setTimeout(Long timeout) {
        this.tf.setTimeout(timeout);
    }

    private String defaultName() {
        return this.fetcher.getClass().getName();
    }

    public String fetcherName() {
        return this.fetcherName != null ? this.fetcherName : this.defaultName();
    }

    public void setFetcherName(String fetcherName) {
        this.fetcherName = fetcherName;
    }

    public String toString() {
        return this.fetcherName() + "\t" + this.args;
    }

    public int hashCode() {
        int hashCode = this.fetcher.hashCode() + this.context.hashCode();
        if (this.args != null) {
            hashCode += this.args.hashCode();
        }
        return hashCode;
    }

    @Override
    public void run() {
        try {
            this.copyLocals();
            Object work = this.fetcher.work(this.args);
            this.tf.set(work);
            this.context.putResult(this.fetcherName(), work);
        }
        catch (Exception ex) {
            this.context.throwException(this.fetcherName(), ex);
        }
    }

    private void copyLocals() {
        Set<ThreadLocal> tls = TaskContext.attachedThreadLocals();
        for (ThreadLocal tl : tls) {
            LoggerService.debug((String)"copyLocals with thread:{} and value:{} ", (Object[])new Object[]{tl, this.context.attachedthreadLocalValues().get(tl)});
            tl.set(this.context.attachedthreadLocalValues().get(tl));
        }
    }
}

