/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.thread;

import com.baijia.tianxiao.task.local.constants.DefaultThreadPoolConfig;
import com.baijia.tianxiao.task.local.constants.ThreadPoolConfig;
import com.baijia.tianxiao.task.local.task.thread.CleanableThreadPoolExecutor;
import com.baijia.tianxiao.task.local.task.thread.WorkUnit;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.math.BigDecimal;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class TaskManager {
    private static volatile ThreadPoolConfig config = new DefaultThreadPoolConfig();
    private static volatile BlockingQueue<Runnable> taskQueue = new ArrayBlockingQueue<Runnable>(config.maxCacheTaskNum());
    private static volatile ThreadPoolExecutor threadPool = new CleanableThreadPoolExecutor(config.coreTaskNum(), config.maxTaskNum(), 10L, TimeUnit.SECONDS, taskQueue, (ThreadFactory)new CustomizableThreadFactory("multi-task-pool-"), new ThreadPoolExecutor.CallerRunsPolicy());
    private static AtomicBoolean refreshed;

    public static void refreshConfig(ThreadPoolConfig tpConfig) {
        if (refreshed.compareAndSet(false, true)) {
            threadPool.shutdown();
            config = tpConfig;
            taskQueue = new ArrayBlockingQueue<Runnable>(config.maxCacheTaskNum());
            threadPool = new ThreadPoolExecutor(config.coreTaskNum(), config.maxTaskNum(), 10L, TimeUnit.SECONDS, taskQueue, (ThreadFactory)new CustomizableThreadFactory("multi-task-pool-"), new ThreadPoolExecutor.CallerRunsPolicy());
            TaskManager.LoggerServiceThreadPoolInfo();
        }
    }

    public static void LoggerServiceThreadPoolInfo() {
        String LoggerServiceFormat = "CORE_TASK_NUM:%s MAX_TASK_NUM:%s MAX_CACHE_TASK_NUM:%s TASK_TIMEOUT_MILL_SECONDS:%s AVAILABLE_PROCESSORs:%s";
        LoggerService.info((String)String.format(LoggerServiceFormat, config.coreTaskNum(), config.maxTaskNum(), config.maxCacheTaskNum(), config.taskTimeoutMillSeconds(), Runtime.getRuntime().availableProcessors()), (Object[])new Object[0]);
    }

    public static ThreadPoolConfig config() {
        return config;
    }

    public static int getTaskCacheCount() {
        return taskQueue.size();
    }

    public <T> Future<T> invoke(Callable<T> task) {
        if (taskQueue.size() > 1) {
            LoggerService.debug((String)("ReportTaskManager current taskQueue size is:" + taskQueue.size()), (Object[])new Object[0]);
        }
        this.checkQueueFullThenSleep();
        Future<T> result = threadPool.submit(task);
        return result;
    }

    public void invoke(Runnable task) {
        if (taskQueue.size() > 1) {
            LoggerService.debug((String)("ReportTaskManager current taskQueue size is:" + taskQueue.size()), (Object[])new Object[0]);
        }
        this.checkQueueFullThenSleep();
        threadPool.execute(task);
    }

    private void checkQueueFullThenSleep() {
        while (taskQueue.size() >= config.maxCacheTaskNum()) {
            LoggerService.info((String)"TaskPoolManager thread pool blocking queue is full.", (Object[])new Object[0]);
            TaskManager.sleep(config.queueFullSleepTime());
        }
    }

    public static final void sleep(int miliSeconds) {
        try {
            Thread.sleep(miliSeconds);
        }
        catch (InterruptedException e) {
            LoggerService.error((String)"Thread sleep is interrupted", (Object[])new Object[]{e});
        }
    }

    public static WorkUnit newWorkUnit() {
        if (taskQueue.size() > 0) {
            LoggerService.debug((String)"ReportTaskManager current taskQueue size is:", (Object[])new Object[]{taskQueue.size()});
        }
        return new WorkUnit(threadPool);
    }

    public static WorkUnit newWorkUnit(Executor executor) {
        if (executor == null) {
            return TaskManager.newWorkUnit();
        }
        return new WorkUnit(executor);
    }

    public static double computeWeight() {
        int totalTaskNum = threadPool.getActiveCount();
        int maxTaskNum = threadPool.getMaximumPoolSize();
        int totalCacheTask = taskQueue.size();
        int maxCacheTask = config.maxCacheTaskNum();
        return new BigDecimal(1.0 - (double)(totalCacheTask + totalTaskNum) / (double)(maxCacheTask + maxTaskNum)).setScale(3, 4).doubleValue();
    }

    public static void main(String[] args) {
        TaskManager.test(15, 20, 0, 20);
        TaskManager.test(15, 40, 0, 20);
    }

    static void test(int totalTaskNum, int maxTaskNum, int totalCacheTask, int maxCacheTask) {
        double weight = 1.0 - (double)(totalCacheTask + totalTaskNum) / (double)(maxCacheTask + maxTaskNum);
        weight = new BigDecimal(weight).setScale(3, 4).doubleValue();
        LoggerService.info((String)"weight:{} ", (Object[])new Object[]{weight});
    }

    static {
        TaskManager.LoggerServiceThreadPoolInfo();
        refreshed = new AtomicBoolean(false);
    }
}

