/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.thread;

import com.baijia.tianxiao.task.local.exception.TaskBizException;
import com.baijia.tianxiao.task.local.exception.TaskTimeoutException;
import com.baijia.tianxiao.task.local.task.monitor.PullResultMonitor;
import com.baijia.tianxiao.task.local.task.thread.MultiResult;
import com.baijia.tianxiao.task.local.task.thread.TaskFuture;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TaskContext
implements MultiResult {
    private ConcurrentHashMap<String, TaskFuture> taskFutureMap = new ConcurrentHashMap();
    private static Set<ThreadLocal> threadLocalSet = new HashSet<ThreadLocal>();
    private Map<String, Object> result = new ConcurrentHashMap<String, Object>();
    private Map<String, Exception> exception = new ConcurrentHashMap<String, Exception>();
    private Map<ThreadLocal, Object> threadLocalValues = new HashMap<ThreadLocal, Object>();
    private Map<String, Object> attribute = new ConcurrentHashMap<String, Object>();

    @Override
    public <E> void putResult(String key, E value) {
        if (value != null) {
            this.result.put(key, value);
        }
    }

    public void putResult(String key, TaskFuture taskFuture) {
        if (taskFuture != null) {
            this.taskFutureMap.put(key, taskFuture);
        }
    }

    public void putTaskFutureMap(Map<String, TaskFuture> taskFutureMap) {
        if (taskFutureMap != null) {
            this.taskFutureMap.putAll(taskFutureMap);
        }
    }

    public void throwException(String key, Exception value) {
        this.exception.put(key, value);
    }

    @Override
    public <E> E getResult(String taskName) {
        return this.getResultWitTimeout(taskName, new Long[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E getResultWitTimeout(String taskName, Long ... waitTime) {
        block10: {
            Long waitTimeLong;
            Exception ex = this.exception.get(taskName);
            if (ex != null) {
                LoggerService.error((String)"Execute fail:", (Object[])new Object[]{ex});
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new TaskBizException(ex);
            }
            if (this.result.containsKey(taskName)) {
                return (E)this.result.get(taskName);
            }
            PullResultMonitor monitor = PullResultMonitor.monitor(taskName);
            TaskFuture taskFuture = this.taskFutureMap.get(taskName);
            Long l = waitTimeLong = GenericsUtils.notNullAndEmpty((Object)waitTime) && waitTime[0] != 1L ? waitTime[0] : null;
            if (taskFuture == null) break block10;
            if (waitTimeLong != null) {
                Object t;
                try {
                    t = taskFuture.get(waitTimeLong, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new TaskTimeoutException(e);
                }
                return (E)t;
            }
            Object t = taskFuture.get();
            return (E)t;
            finally {
                PullResultMonitor.remoteMonitor(monitor);
            }
        }
        return null;
    }

    @Override
    public <E> E getResult(String taskName, long timeout) {
        return this.getResultWitTimeout(taskName, timeout);
    }

    @Override
    public Map<String, Object> getResult() {
        return this.result;
    }

    @Override
    public void clean() {
        if (this.result != null) {
            this.result.clear();
            this.result = null;
            this.exception.clear();
            this.exception = null;
            this.threadLocalValues.clear();
            this.threadLocalValues = null;
        }
    }

    private TaskContext() {
    }

    public static TaskContext newContext() {
        return new TaskContext();
    }

    public static void attachThreadLocal(ThreadLocal threadLocal) {
        threadLocalSet.add(threadLocal);
    }

    public static void detachThreadLocal(ThreadLocal threadLocal) {
        threadLocalSet.remove(threadLocal);
    }

    public static Set<ThreadLocal> attachedThreadLocals() {
        return threadLocalSet;
    }

    public Map<ThreadLocal, Object> attachedthreadLocalValues() {
        return this.threadLocalValues;
    }

    public void copyAttachedthreadLocalValues() {
        for (ThreadLocal tl : threadLocalSet) {
            LoggerService.debug((String)"copyAttachedthreadLocalValues :{} with value:{} ", (Object[])new Object[]{tl, tl.get()});
            this.threadLocalValues.put(tl, tl.get());
        }
    }

    public <T> T getAttribute(String key) {
        return (T)this.attribute.get(key);
    }

    public <T> TaskContext putAttribute(String key, T value) {
        this.attribute.put(key, value);
        return this;
    }
}

