/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.thread;

import com.baijia.tianxiao.task.local.exception.TaskFutureWaitException;
import com.baijia.tianxiao.task.local.task.thread.TaskFuture;
import com.baijia.tianxiao.task.local.task.thread.TaskManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleTaskFutrue
implements TaskFuture {
    private final CountDownLatch internalWaiter = new CountDownLatch(1);
    private volatile Object result;
    private Long timeout;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private volatile boolean hasInit = false;

    public SimpleTaskFutrue() {
    }

    public SimpleTaskFutrue(Long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public <T> T get() {
        try {
            if (this.timeout != null) {
                return this.get(this.timeout, this.timeUnit);
            }
            return this.get(-1L, null);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TaskFutureWaitException("", e);
        }
    }

    @Override
    public <T> T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (timeout == -1L) {
            this.internalWaiter.await();
            return (T)this.result;
        }
        if (this.internalWaiter.await(timeout, unit)) {
            return (T)this.result;
        }
        throw new TimeoutException();
    }

    @Override
    public void set(Object result) {
        this.result = result;
        this.internalWaiter.countDown();
    }

    @Override
    public void append(Object result, TaskFuture.AppendHandler handler, boolean finish) {
        if (!this.hasInit) {
            this.result = handler.init();
            this.hasInit = true;
        }
        handler.append(this.result, result);
        if (finish) {
            this.internalWaiter.countDown();
        }
    }

    public void setTimeout(Long timeout) {
        long timeout_ = timeout > 0L ? timeout.longValue() : TaskManager.config().taskTimeoutMillSeconds();
        this.timeout = timeout_;
    }
}

