/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task.monitor;

import com.baijia.tianxiao.task.local.exception.TaskTimeoutException;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class PullResultMonitor {
    private static final ConcurrentLinkedQueue<PullResultMonitor> monitorQueue = new ConcurrentLinkedQueue();
    public static final String PULL_REQUEST_TIME_OUT_FORMAT = "find a pullRequest operator :%s , and after ten minute it still not success ";
    String taskBeanName;
    long timestampe;
    Object paramObj;

    public static PullResultMonitor monitor(String taskBeanName) {
        PullResultMonitor pullResultMonitor = new PullResultMonitor(taskBeanName);
        monitorQueue.add(pullResultMonitor);
        return pullResultMonitor;
    }

    public static void remoteMonitor(PullResultMonitor pullResultMonitor) {
        monitorQueue.remove(pullResultMonitor);
    }

    private PullResultMonitor(String taskBeanName) {
        this.taskBeanName = taskBeanName;
        this.timestampe = System.currentTimeMillis();
    }

    public String toString() {
        return "PullResultMonitor [taskBeanName=" + this.taskBeanName + ", timestampe=" + this.timestampe + ", paramObj=" + this.paramObj + "]";
    }

    static {
        Thread monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        TimeUnit.MINUTES.sleep(10L);
                        PullResultMonitor prm = null;
                        while (true) {
                            if ((prm = (PullResultMonitor)monitorQueue.peek()) == null || System.currentTimeMillis() - prm.timestampe < 3600000L) continue block2;
                            monitorQueue.remove(prm);
                            LoggerService.error((String)String.format(PullResultMonitor.PULL_REQUEST_TIME_OUT_FORMAT, prm), (Object[])new Object[]{new TaskTimeoutException("")});
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        monitorThread.setDaemon(true);
        monitorThread.start();
    }
}

