/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.task;

import com.baijia.tianxiao.task.local.common.TaskPair;
import com.baijia.tianxiao.task.local.constants.ThreadPoolConfig;
import com.baijia.tianxiao.task.local.forkjoin.ForkJoin;
import com.baijia.tianxiao.task.local.policy.DefautExecutePolicy;
import com.baijia.tianxiao.task.local.policy.ExecutePolicy;
import com.baijia.tianxiao.task.local.spring.integration.TaskBeanContainer;
import com.baijia.tianxiao.task.local.task.AbstractParallelExePool;
import com.baijia.tianxiao.task.local.task.CustomizedParallelExePool;
import com.baijia.tianxiao.task.local.task.DefaultTaskWrapper;
import com.baijia.tianxiao.task.local.task.thread.MultiResult;
import com.baijia.tianxiao.task.local.task.thread.TaskContext;
import com.baijia.tianxiao.task.local.task.thread.TaskManager;
import com.baijia.tianxiao.task.local.task.thread.TaskWrapper;
import com.baijia.tianxiao.task.local.task.thread.WorkUnit;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SimpleParallelExePool
extends AbstractParallelExePool
implements CustomizedParallelExePool {
    public final String IS_SYSTEM_EXECUTOR = "IS_SYSTEM_EXECUTOR";

    @Override
    public MultiResult submit(List<TaskPair> taskPairs) {
        return this.submit((ExecutePolicy)DefautExecutePolicy.instance(), taskPairs.toArray(new TaskPair[0]));
    }

    @Override
    public MultiResult submit(TaskPair ... taskPairs) {
        return this.submit((ExecutePolicy)DefautExecutePolicy.instance(), taskPairs);
    }

    @Override
    public MultiResult submit(ExecutePolicy policy, TaskPair ... taskPairs) {
        return this.submit(null, policy, taskPairs);
    }

    @Override
    public MultiResult submit(Executor executor, TaskPair ... taskPairs) {
        return this.submit(executor, DefautExecutePolicy.instance(), taskPairs);
    }

    @Override
    public MultiResult submit(Executor executor, ExecutePolicy policy, TaskPair ... taskPairs) {
        TaskContext context = TaskContext.newContext();
        this.beforeSubmit(context, policy, taskPairs);
        TaskPair[] lTaskPairs = (TaskPair[])context.getAttribute("taskPairs");
        List<TaskWrapper> fetchers = this.getTaskWrapperFactory(this.container, context, lTaskPairs);
        WorkUnit workUnit = TaskManager.newWorkUnit(executor);
        context.copyAttachedthreadLocalValues();
        for (TaskWrapper fetcher : fetchers) {
            fetcher.setTimeout(policy.taskTimeout());
            workUnit.submitForTaskFuture(fetcher);
        }
        boolean isSystemExecutor = false;
        if (executor == null) {
            isSystemExecutor = true;
        }
        context.putAttribute("IS_SYSTEM_EXECUTOR", isSystemExecutor);
        this.onSubmit(context, policy, taskPairs);
        this.postSubmit(context, policy, taskPairs);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskWrapper> getTaskWrapperFactory(TaskBeanContainer container, TaskContext context, TaskPair[] queryPairs) {
        if (this.taskWrapperFactory == null) {
            LoggerService.info((String)"current TaskWrapperFactory is null ", (Object[])new Object[0]);
            SimpleParallelExePool simpleParallelExePool = this;
            synchronized (simpleParallelExePool) {
                if (this.taskWrapperFactory == null) {
                    this.taskWrapperFactory = new DefaultTaskWrapper();
                }
            }
        }
        return this.taskWrapperFactory.wrapperFetcher(container, context, queryPairs);
    }

    @Override
    public <PARAM, RESULT> RESULT submit(TaskPair taskPair, ForkJoin<PARAM, RESULT> forkJoin) {
        return this.submit((ExecutePolicy)DefautExecutePolicy.instance(), taskPair, forkJoin);
    }

    @Override
    public <PARAM, RESULT> RESULT submit(ExecutePolicy policy, TaskPair taskPair, ForkJoin<PARAM, RESULT> forkJoin) {
        List<Object> params = forkJoin.fork(taskPair.field2);
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        int version = 0;
        ArrayList<TaskPair> taskPairs = new ArrayList<TaskPair>();
        for (Object param : params) {
            taskPairs.add(taskPair.wrap((String)taskPair.field1 + '#' + version++, param));
        }
        TaskContext ctx = (TaskContext)this.submit(policy, taskPairs.toArray(new TaskPair[0]));
        ArrayList results = new ArrayList();
        for (String taskName : ctx.getResult().keySet()) {
            results.add(ctx.getResult(taskName));
        }
        return forkJoin.join(results);
    }

    public SimpleParallelExePool(ThreadPoolConfig tpConfig) {
        super(tpConfig);
    }

    public SimpleParallelExePool() {
    }

    @Override
    public MultiResult submitRandom(TaskPair ... taskPairs) {
        return this.submit(taskPairs);
    }
}

