/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.spring.integration;

import com.baijia.tianxiao.task.local.exception.TaskBizException;
import com.baijia.tianxiao.task.local.task.Taskable;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TaskBeanHelper {
    private static final int NORMAL_PARAM_LENTH = 1;

    public static Taskable<?> newFetcher(final Object service, final Method method, final String beanName, final int paramLen) {
        if (1 == paramLen) {
            return TaskBeanHelper.newNormalFetcher(service, method, beanName);
        }
        return new Taskable<Object>(){

            @Override
            public <E> Object work(E request) {
                return TaskBeanHelper.invokeMethod(service, method, beanName, paramLen, request);
            }
        };
    }

    private static Taskable<?> newNormalFetcher(final Object service, final Method method, final String beanName) {
        return new Taskable<Object>(){

            @Override
            public <E> Object work(E request) {
                return TaskBeanHelper.invokeMethod(service, method, beanName, 1, request);
            }
        };
    }

    private static <E> Object invokeMethod(Object service, Method method, String beanName, int paramLen, E request) {
        Exception ex = null;
        try {
            return TaskBeanHelper.invokeMethod(service, method, request, paramLen);
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            LoggerService.error((String)"Fail to run task bean: {} {} ", (Object[])new Object[]{beanName, e});
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ex = e;
        }
        catch (Exception e) {
            ex = e;
        }
        LoggerService.error((String)"Fail to run task bean: {} {} ", (Object[])new Object[]{beanName, ex});
        throw new TaskBizException(LoggerService.formatOutput((String)"Fail to run task bean: {} ", (Object[])new Object[]{beanName}), ex);
    }

    private static <T> Object invokeMethod(Object service, Method method, T request, int paramLen) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        switch (paramLen) {
            case 0: {
                return method.invoke(service, new Object[0]);
            }
            case 1: {
                return method.invoke(service, request);
            }
        }
        Object[] params = (Object[])request;
        return method.invoke(service, params);
    }
}

