/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.spring.integration;

import com.baijia.tianxiao.task.local.annotation.TaskBean;
import com.baijia.tianxiao.task.local.annotation.TaskService;
import com.baijia.tianxiao.task.local.exception.TaskBizException;
import com.baijia.tianxiao.task.local.spring.integration.TaskBeanHelper;
import com.baijia.tianxiao.task.local.task.Taskable;
import com.baijia.tianxiao.util.bean.LoggerService;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class TaskBeanContainer
implements ApplicationContextAware,
PriorityOrdered {
    private static ApplicationContext applicationContext;
    private static Map<String, Taskable<?>> container;
    private static AtomicBoolean initing;
    private static CountDownLatch hasInit;
    private static volatile String springContainerInstanceFlag;

    public static void initFetcherContainer() {
        TaskBeanContainer.initFetcherContainer((ListableBeanFactory)applicationContext);
    }

    public static void initFetcherContainer(ListableBeanFactory factory) {
        if (initing.get()) {
            TaskBeanContainer.waitInit();
            return;
        }
        if (initing.compareAndSet(false, true)) {
            Map fetcherServices = factory.getBeansWithAnnotation(TaskService.class);
            for (Object service : fetcherServices.values()) {
                TaskBeanContainer.regiserOneService(service);
            }
            hasInit.countDown();
        } else {
            TaskBeanContainer.waitInit();
        }
    }

    private static void waitInit() {
        try {
            hasInit.await();
        }
        catch (InterruptedException e) {
            LoggerService.error((String)"Interrupted while waiting init.", (Object[])new Object[]{e});
        }
    }

    public static void regiserOneService(Object service) {
        Class<?> clazz = service.getClass();
        for (Method method : ReflectionUtils.getAllDeclaredMethods(clazz)) {
            TaskBean bean = method.getAnnotation(TaskBean.class);
            if (bean == null) continue;
            TaskBeanContainer.registerFetcher(service, method, bean.value());
        }
    }

    public <T> T bean(String beanName) {
        Taskable<?> bean = container.get(beanName);
        if (bean != null) {
            return (T)bean;
        }
        return TaskBeanContainer.getBean(beanName);
    }

    public Taskable<?> task(String beanName) {
        return (Taskable)this.bean(beanName);
    }

    private static void registerFetcher(Object service, Method method, String beanName) {
        if (TaskBeanContainer.containsBean(beanName)) {
            throw new TaskBizException("Fetcher bean duplicate for Spring:" + beanName);
        }
        int paramLen = method.getGenericParameterTypes().length;
        Taskable<?> fetcher = TaskBeanHelper.newFetcher(service, method, beanName, paramLen);
        AutowireCapableBeanFactory factory = applicationContext.getAutowireCapableBeanFactory();
        if (factory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory defaultFactory = (DefaultListableBeanFactory)factory;
            defaultFactory.registerSingleton(beanName, fetcher);
            LoggerService.info((String)("DefaultListableBeanFactory Fetcher register: " + beanName), (Object[])new Object[0]);
        } else if (factory instanceof AbstractBeanFactory) {
            AbstractBeanFactory abstFactory = (AbstractBeanFactory)factory;
            abstFactory.registerSingleton(beanName, fetcher);
            LoggerService.info((String)("AbstractBeanFactory Fetcher register: " + beanName), (Object[])new Object[0]);
        } else {
            container.put(beanName, fetcher);
            LoggerService.info((String)("LocalContainer Fetcher register: " + beanName), (Object[])new Object[0]);
        }
    }

    public static void registerTaskBean(Object service, String beanName, String funcName, Class<?> ... paramsType) {
        Method method = null;
        try {
            method = service.getClass().getMethod(funcName, paramsType);
        }
        catch (NoSuchMethodException e) {
            LoggerService.error((String)"register TaskBean fail:", (Object[])new Object[]{e});
        }
        TaskBeanContainer.registerFetcher(service, method, beanName);
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static <T> T getBean(String name) {
        return (T)applicationContext.getBean(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TaskBeanContainer.applicationContext = applicationContext;
        String newValue = String.valueOf(applicationContext.hashCode());
        LoggerService.info((String)("fetcherBean container id:" + newValue), (Object[])new Object[0]);
        if (!springContainerInstanceFlag.equals(newValue)) {
            hasInit = new CountDownLatch(1);
            initing.set(false);
            TaskBeanContainer.initFetcherContainer();
            springContainerInstanceFlag = newValue;
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static {
        container = new ConcurrentHashMap();
        initing = new AtomicBoolean(false);
        hasInit = new CountDownLatch(1);
        springContainerInstanceFlag = "";
    }
}

