/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.task.local.initService;

import com.baijia.tianxiao.task.local.initService.BeanLocatorOfTypes;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class BeanCache {
    private static ConcurrentHashMap<Class<?>, List<Object>> beanCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getBean(Class<? extends T> clazz) {
        BeanCache.checkout(clazz, "");
        List<Object> allBeans = beanCache.get(clazz);
        Object bean = null;
        if (allBeans == null || allBeans.size() == 0) {
            if (BeanLocatorOfTypes.isInit()) {
                bean = BeanLocatorOfTypes.getBeanByRquire(clazz);
            }
        } else {
            List<Object> list = allBeans;
            synchronized (list) {
                if (allBeans.size() > 1) {
                    throw new IllegalStateException(String.format("try to find a instance of class:[%s] but find more:%s", clazz.getName(), allBeans.size()));
                }
                bean = allBeans.get(0);
            }
        }
        if (bean == null) {
            throw new IllegalStateException(String.format("can not find any instance of type:[%s]", clazz.getName()));
        }
        return (T)bean;
    }

    private static void checkout(Object obj, String errrorMsg) {
        if (GenericsUtils.isNullOrEmpty((Object)obj)) {
            throw new IllegalArgumentException("key of class can not be null");
        }
    }

    public static <T> List<T> getBeansOfType(Class<T> type) {
        BeanCache.checkout(type, "");
        List<Object> list = beanCache.get(type);
        if ((list == null || list.size() == 0) && BeanLocatorOfTypes.isInit()) {
            Collection<T> beans = BeanLocatorOfTypes.getBeansOfType(type);
            list = new ArrayList<T>(beans);
        }
        if (list == null || list.size() == 0) {
            throw new IllegalStateException(String.format("can not find any instance of type:[%s]", type.getName()));
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBean(Class<?> objClass, Object bean) {
        BeanCache.checkout(objClass, "");
        BeanCache.checkout(bean, "value can not be null");
        ArrayList<Object> beans = new ArrayList<Object>();
        List putIfAbsent = beanCache.putIfAbsent(objClass, beans);
        if (putIfAbsent == null) {
            beans.add(bean);
        } else {
            List list = putIfAbsent;
            synchronized (list) {
                if (!putIfAbsent.contains(bean)) {
                    putIfAbsent.add(bean);
                }
            }
        }
        BeanCache.registerBeanWithInterface(objClass, Arrays.asList(bean));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBeanes(Class objClass, List beanNeedRegister) {
        BeanCache.checkout(objClass, "");
        BeanCache.checkout(beanNeedRegister, "value can not be null");
        List<Object> putIfAbsent = beanCache.putIfAbsent(objClass, beanNeedRegister);
        if (putIfAbsent != null) {
            List<Object> list = putIfAbsent;
            synchronized (list) {
                putIfAbsent.removeAll(beanNeedRegister);
                beanNeedRegister.addAll(putIfAbsent);
            }
        }
    }

    private static void registerBeanWithInterface(Class<? extends Object> clazz, List<Object> beanes) {
        if (clazz.getName().equals("java.lang.Object")) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<? extends Object> parentClass = clazz.getSuperclass();
        if (parentClass != null) {
            BeanCache.registerBean(parentClass, beanes);
            BeanCache.registerBeanWithInterface(parentClass, beanes);
        }
        if (GenericsUtils.notNullAndEmpty(interfaces)) {
            for (Class<?> clz : interfaces) {
                BeanCache.registerBean(clz, beanes);
                BeanCache.registerBeanWithInterface(clz, beanes);
            }
        }
    }
}

