/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dev.lib.threadLocalClear;

import com.baijia.tianxiao.dev.lib.threadLocalClear.ThreadLocalChangeListener;
import com.baijia.tianxiao.dev.lib.threadLocalClear.ThreadLocalCleaner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorWithThreadLocalClean
extends ThreadPoolExecutor {
    private final ThreadLocalChangeListener listener;
    private static final ThreadLocal<ThreadLocalCleaner> local = new ThreadLocal();

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ThreadLocalChangeListener.EMPTY);
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, ThreadLocalChangeListener.EMPTY);
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler, ThreadLocalChangeListener.EMPTY);
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, ThreadLocalChangeListener.EMPTY);
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadLocalChangeListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.listener = listener;
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, ThreadLocalChangeListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.listener = listener;
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler, ThreadLocalChangeListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.listener = listener;
    }

    public ThreadPoolExecutorWithThreadLocalClean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, ThreadLocalChangeListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.listener = listener;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        assert (t == Thread.currentThread());
        local.set(new ThreadLocalCleaner(this.listener));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ThreadLocalCleaner cleaner = local.get();
        local.remove();
        cleaner.cleanup();
    }
}

