/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dev.lib.threadLocalClear;

import com.baijia.tianxiao.dev.lib.threadLocalClear.BiConsumer;
import com.baijia.tianxiao.dev.lib.threadLocalClear.DefaultThreadLocalChangeListener;
import com.baijia.tianxiao.dev.lib.threadLocalClear.ThreadLocalChangeListener;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCleaner
implements Closeable {
    private final ThreadLocalChangeListener listener;
    private static final ThreadLocalChangeListener defaultListener = new DefaultThreadLocalChangeListener();
    private static final ThreadLocal<Reference<?>[]> copyOfThreadLocals = new ThreadLocal();
    private static final ThreadLocal<Reference<?>[]> copyOfInheritableThreadLocals = new ThreadLocal();
    private static final Field threadLocalsField;
    private static final Field inheritableThreadLocalsField;
    private static final Class<?> threadLocalMapClass;
    private static final Field tableField;
    private static final Class<?> threadLocalMapEntryClass;
    private static final Field threadLocalEntryValueField;

    public ThreadLocalCleaner() {
        this(defaultListener);
    }

    public static Collection<Map.Entry<ThreadLocal<?>, Object>> findAll(Thread thread) {
        final ArrayList result = new ArrayList();
        BiConsumer adder = new BiConsumer<ThreadLocal<?>, Object>(){

            @Override
            public void accept(ThreadLocal<?> t, Object u) {
                result.add(new AbstractMap.SimpleImmutableEntry(t, u));
            }
        };
        ThreadLocalCleaner.forEach(thread, adder);
        return result;
    }

    public static Map<ThreadLocal<?>, Object> findAllRetMap(Thread thread) {
        final HashMap result = new HashMap();
        BiConsumer adder = new BiConsumer<ThreadLocal<?>, Object>(){

            @Override
            public void accept(ThreadLocal<?> t, Object u) {
                result.put(t, u);
            }
        };
        ThreadLocalCleaner.forEach(thread, adder);
        return result;
    }

    public ThreadLocalCleaner(ThreadLocalChangeListener listener) {
        this.listener = listener;
        ThreadLocalCleaner.saveOldThreadLocals();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    public void cleanup() {
        this.diff(threadLocalsField, copyOfThreadLocals.get());
        this.diff(inheritableThreadLocalsField, copyOfInheritableThreadLocals.get());
        ThreadLocalCleaner.restoreOldThreadLocals();
    }

    public static void forEach(Thread thread, BiConsumer<ThreadLocal<?>, Object> consumer) {
        ThreadLocalCleaner.forEach(thread, threadLocalsField, consumer);
        ThreadLocalCleaner.forEach(thread, inheritableThreadLocalsField, consumer);
    }

    public static void cleanup(Thread thread) {
        try {
            threadLocalsField.set(thread, null);
            inheritableThreadLocalsField.set(thread, null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not clear thread locals: " + e);
        }
    }

    private void diff(Field field, Reference<?>[] backup) {
        try {
            Thread thread = Thread.currentThread();
            Object threadLocals = field.get(thread);
            if (threadLocals == null) {
                if (backup != null) {
                    for (Reference<?> reference : backup) {
                        this.changed(thread, reference, ThreadLocalChangeListener.Mode.REMOVED);
                    }
                }
                return;
            }
            Reference[] current = (Reference[])tableField.get(threadLocals);
            if (backup == null) {
                for (Reference reference : current) {
                    if (reference != null && (reference.get() == copyOfThreadLocals || reference.get() == copyOfInheritableThreadLocals)) continue;
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.ADDED);
                }
            } else {
                block4: for (Reference reference : current) {
                    if (reference == null || reference.get() == copyOfThreadLocals || reference.get() == copyOfInheritableThreadLocals) continue;
                    for (Reference<?> reference2 : backup) {
                        if (reference == reference2) continue block4;
                    }
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.ADDED);
                }
                block6: for (Reference reference : backup) {
                    for (Reference<?> reference3 : current) {
                        if (reference3 == reference) continue block6;
                    }
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.REMOVED);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    private void changed(Thread thread, Reference<?> reference, ThreadLocalChangeListener.Mode mode) throws IllegalAccessException {
        if (reference == null) {
            return;
        }
        this.listener.changed(mode, thread, (ThreadLocal)reference.get(), threadLocalEntryValueField.get(reference));
    }

    private static Field field(Class<?> c, String name) throws NoSuchFieldException {
        Field field = c.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private static Class<?> inner(Class<?> clazz, String name) {
        for (Class<?> c : clazz.getDeclaredClasses()) {
            if (!c.getSimpleName().equals(name)) continue;
            return c;
        }
        throw new IllegalStateException("Could not find inner class " + name + " in " + clazz);
    }

    private static void forEach(Thread thread, Field field, BiConsumer<ThreadLocal<?>, Object> consumer) {
        try {
            Object threadLocals = field.get(thread);
            if (threadLocals != null) {
                Reference[] table;
                for (Reference ref : table = (Reference[])tableField.get(threadLocals)) {
                    ThreadLocal key;
                    if (ref == null || (key = (ThreadLocal)ref.get()) == null) continue;
                    Object value = threadLocalEntryValueField.get(ref);
                    consumer.accept(key, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void saveOldThreadLocals() {
        copyOfThreadLocals.set(ThreadLocalCleaner.copy(threadLocalsField));
        copyOfInheritableThreadLocals.set(ThreadLocalCleaner.copy(inheritableThreadLocalsField));
    }

    private static Reference<?>[] copy(Field field) {
        try {
            Thread thread = Thread.currentThread();
            Object threadLocals = field.get(thread);
            if (threadLocals == null) {
                return null;
            }
            Reference[] table = (Reference[])tableField.get(threadLocals);
            return Arrays.copyOf(table, table.length);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    private static void restoreOldThreadLocals() {
        try {
            ThreadLocalCleaner.restore(threadLocalsField, copyOfThreadLocals.get());
            ThreadLocalCleaner.restore(inheritableThreadLocalsField, copyOfInheritableThreadLocals.get());
        }
        finally {
            copyOfThreadLocals.remove();
            copyOfInheritableThreadLocals.remove();
        }
    }

    private static void restore(Field field, Object value) {
        try {
            Thread thread = Thread.currentThread();
            if (value == null) {
                field.set(thread, null);
            } else {
                tableField.set(field.get(thread), value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    static {
        try {
            threadLocalsField = ThreadLocalCleaner.field(Thread.class, "threadLocals");
            inheritableThreadLocalsField = ThreadLocalCleaner.field(Thread.class, "inheritableThreadLocals");
            threadLocalMapClass = ThreadLocalCleaner.inner(ThreadLocal.class, "ThreadLocalMap");
            tableField = ThreadLocalCleaner.field(threadLocalMapClass, "table");
            threadLocalMapEntryClass = ThreadLocalCleaner.inner(threadLocalMapClass, "Entry");
            threadLocalEntryValueField = ThreadLocalCleaner.field(threadLocalMapEntryClass, "value");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Could not locate threadLocals field in Thread.  Will not be able to clear thread locals: " + e);
        }
    }
}

