/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.statistic.dao.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TxFinanceRecordDayDaoImpl
extends JdbcTemplateDaoSupport<TxFinanceRecordDay>
implements TxFinanceRecordDayDao {
    public TxFinanceRecordDayDaoImpl() {
        super(TxFinanceRecordDay.class);
    }

    @Override
    public TxFinanceRecordDay getByDayType(Long orgId, String mdate, int opType, int opTo, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("mdate", (Serializable)((Object)mdate));
        builder.eq("opType", (Serializable)Integer.valueOf(opType));
        builder.eq("opTo", (Serializable)Integer.valueOf(opTo));
        builder.setMaxSize(Integer.valueOf(1));
        return (TxFinanceRecordDay)this.uniqueResult(builder);
    }

    @Override
    public List<TxFinanceRecordDay> list(Long orgId, Date startDate, Date endDate, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.ge("mdate", (Serializable)startDate);
        builder.le("mdate", (Serializable)endDate);
        builder.desc("mdate");
        return this.queryList(builder);
    }

    @Override
    public Double getIncome(Long orgId, Date startDate, Date endDate) {
        Double money;
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>();
        param.put("orgId", orgId);
        String sql = "select ifnull(sum(op_price),0) from yunying.tx_finance_record_day where org_id = :orgId and op_to = 1";
        if (startDate != null && endDate != null) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
            sql = sql + " and mdate <= :endDate and mdate >= :startDate";
        }
        return (money = (Double)this.getNamedJdbcTemplate().queryForObject(sql, param, Double.class)) == null ? 0.0 : money;
    }

    @Override
    public Double getIncomes(List<Integer> orgIds, Date startDate, Date endDate) {
        Double money;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("opPrice");
        builder.in("orgId", orgIds);
        builder.eq("opTo", (Serializable)Integer.valueOf(1));
        if (startDate != null && endDate != null) {
            builder.le("mdate", (Serializable)endDate);
            builder.ge("mdate", (Serializable)startDate);
        }
        return (money = (Double)this.queryForObject(builder, Double.class)) == null ? 0.0 : money;
    }

    @Override
    public Map<Integer, Double> queryByOrgIds(List<Integer> orgIds, Date startDate, Date endDate) {
        String sql = "select sum(op_price) as c,org_id from yunying.tx_finance_record_day where op_to=1 and mdate <= :endDate and mdate >= :startDate and org_id in (:orgIds)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        sql = sql + " group by org_id";
        final HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ret.put(rs.getInt("org_id"), rs.getDouble("c"));
                return null;
            }
        });
        return ret;
    }
}

