/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class TxStudentTagDaoImpl
extends JdbcTemplateDaoSupport<TxStudentTag>
implements TxStudentTagDao {
    private static final Logger log = LoggerFactory.getLogger(TxStudentTagDaoImpl.class);

    public TxStudentTagDaoImpl() {
        super(TxStudentTag.class);
    }

    @Override
    public List<TxStudentTag> getTags(Long studentId, Long orgId, Integer type, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<TxStudentTag> getTags(Collection<Long> studentIds, Long orgId, Integer type, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.in("consultUserId", studentIds);
        } else {
            builder.in("userId", studentIds);
        }
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }

    @Override
    public List<Long> searchByTagValue(Long orgId, String tagValue, String ... queryProps) {
        if (GenericsUtils.isNullOrEmpty((Object)tagValue)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.select("consultUserId");
        builder.eq("orgId", (Serializable)orgId);
        builder.like("content", (Serializable)((Object)tagValue), MatchMode.ANYWHERE);
        log.debug("searchByTagValue==sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryForList(builder, Long.class);
    }

    @Override
    public void updateTag(Long consultUserId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consultUserId);
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.putAll(builder.collectConditionValue());
        this.getNamedJdbcTemplate().update(builder.toUpdateSql(new String[]{"userId"}), (Map)params);
    }

    @Override
    public void delTags(Long userId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        this.getNamedJdbcTemplate().update(builder.toDeleteSqlByCondition(), builder.collectConditionValue());
    }

    @Override
    public Map<String, TxStudentTag> getAndCachedTags(Long studentId, Long orgId, Integer type) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.desc("createTime");
        List result = this.queryList(builder);
        if (result != null && !result.isEmpty()) {
            HashMap ret = Maps.newHashMap();
            for (TxStudentTag tag : result) {
                ret.put(tag.getContent(), tag);
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    @Override
    public TxStudentTag getUniqueTag(Long id, Long orgId, Integer type, Long studentId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("id", (Serializable)id);
        builder.eq("orgId", (Serializable)orgId);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        return (TxStudentTag)this.uniqueResult(builder);
    }

    @Override
    public List<TxStudentTag> getHotTags(Long orgId, Integer listSize, Integer minTagTimes) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT content, count(id) as num FROM yunying.tx_student_tag WHERE org_id=:orgId GROUP BY content ");
        if (minTagTimes != null && minTagTimes > 0) {
            builder.append(" HAVING num>:minTagTimes ");
        }
        builder.append(" ORDER BY num DESC ");
        if (listSize != null && listSize > 0) {
            builder.append(" LIMIT :listSize");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("orgId", orgId);
        params.put("listSize", listSize);
        params.put("minTagTimes", minTagTimes);
        List list = template.query(builder.toString(), params, (RowMapper)new RowMapper<TxStudentTag>(){
            TxStudentTag tag = null;

            public TxStudentTag mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.tag = new TxStudentTag();
                this.tag.setContent(rs.getString("content"));
                return this.tag;
            }
        });
        return list;
    }

    @Override
    public void delTagsByConsulterId(Long consulterId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consulterId);
        builder.eq("orgId", (Serializable)orgId);
        this.getNamedJdbcTemplate().update(builder.toDeleteSqlByCondition(), builder.collectConditionValue());
    }

    @Override
    public List<TxStudentTag> getTagsByConsultId(Long consultId, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consultId);
        builder.eq("orgId", (Serializable)orgId);
        return this.queryList(builder);
    }
}

