/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxStudentCommentDaoImpl
extends JdbcTemplateDaoSupport<TxStudentComment>
implements TxStudentCommentDao {
    public TxStudentCommentDaoImpl() {
        super(TxStudentComment.class);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<Long> getLastDateComments(Long orgId, Date updateTime, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.select("consultUserId");
        builder.eq("orgId", (Serializable)orgId);
        builder.ge("createTime", (Serializable)updateTime);
        builder.groupByNames(new String[]{"consultUserId"});
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (null != page) {
            builder.setPage(page);
        }
        builder.desc("createTime");
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public void updateComment(Long consultUserId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consultUserId);
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.putAll(builder.collectConditionValue());
        this.getNamedJdbcTemplate().update(builder.toUpdateSql(new String[]{"userId"}), (Map)params);
    }

    @Override
    public List<TxStudentComment> listComments(Long studentId, Long orgId, Integer type, Integer isGrowthComment, String ... queryPropes) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPropes);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        if (isGrowthComment != null) {
            builder.eq("growthComments", (Serializable)isGrowthComment);
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getCommentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds, Integer isSystemType, Boolean isStudentComment) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(1) count from yunying.tx_student_comment where org_id in (:orgIds) ";
        if (GenericsUtils.notNullAndEmpty((Object)isSystemType)) {
            sql = sql + " and is_system = :isSystemType ";
            param.put("isSystemType", isSystemType);
        }
        if (isStudentComment.booleanValue()) {
            sql = sql + " and user_id != 0 ";
        }
        if (startTime != null) {
            sql = sql + " and create_time>=:startTime and create_time<=:endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Integer count = rs.getInt("count");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}

