/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgPushCallInfoDaoImpl
extends JdbcTemplateDaoSupport<OrgPushCallInfo>
implements OrgPushCallInfoDao {
    public OrgPushCallInfoDaoImpl() {
        super(OrgPushCallInfo.class);
    }

    @Override
    public List<OrgPushCallInfo> getCallInfoByMinId(Long id, Date time, int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"max size is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (id == null) {
            if (time == null) {
                time = new Date();
            }
            builder.gt("startTime", (Serializable)time);
        } else {
            builder.gt("id", (Serializable)id);
        }
        builder.ne("extention", (Serializable)((Object)""));
        builder.asc("startTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<OrgPushCallInfo> page(Long minId, PageDto pageDto) {
        final ArrayList<OrgPushCallInfo> list = new ArrayList<OrgPushCallInfo>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.callservice_org_call_record WHERE 1=1");
        if (minId != null && minId != 0L) {
            builder.append(" AND id>:minId");
        }
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("minId", minId);
        params.put("start", pageDto.firstNum());
        params.put("size", pageDto.getPageSize());
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            OrgPushCallInfo info;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.info = new OrgPushCallInfo();
                this.info.setConnectedNumber(rs.getString("connected_number"));
                this.info.setConnectedTime(rs.getTimestamp("connected_time"));
                this.info.setCustomerNumber(rs.getString("customer_number"));
                this.info.setDuringTime(rs.getInt("during_time"));
                this.info.setExtention(rs.getString("extention"));
                this.info.setHangUpTime(rs.getTimestamp("hang_up_time"));
                this.info.setId(rs.getLong("id"));
                this.info.setRecordFile(rs.getString("record_file"));
                this.info.setStartTime(rs.getTimestamp("start_time"));
                this.info.setStatus(rs.getInt("status"));
                this.info.setStorageId(rs.getLong("storage_id"));
                this.info.setUniqueId(rs.getString("unique_id"));
                list.add(this.info);
                return 1;
            }
        });
        return list;
    }
}

