/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.referral.impl;

import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class ReferralDaoImpl
extends JdbcTemplateDaoSupport<ReferralInfo>
implements ReferralInfoDao {
    public ReferralDaoImpl() {
        super(ReferralInfo.class);
    }

    @Override
    public Long saveReferral(ReferralInfo ri) {
        this.save(ri, new String[0]);
        return ri.getActivityId();
    }

    @Override
    public void updateReferral(ReferralInfo ri) {
        HashMap<String, Long> updateCondtion = new HashMap<String, Long>();
        updateCondtion.put("orgId", ri.getOrgId());
        updateCondtion.put("activityId", ri.getActivityId());
        super.update(updateCondtion, (Object)ri, new String[0]);
    }

    @Override
    public ReferralInfo getReferralInfo(Long activityId, Long orgId) {
        return this.getReferralInfo(activityId, orgId, DeleteStatus.NORMAL.getValue());
    }

    @Override
    public ReferralInfo getReferralInfo(Long activityId, Long orgId, Integer delStatus) {
        List queryList;
        SingleSqlBuilder sqlBuilder = this.createSqlBuilder(new String[0]);
        sqlBuilder.eq("activityId", (Serializable)activityId);
        if (orgId != null) {
            sqlBuilder.eq("orgId", (Serializable)orgId);
        }
        if (delStatus != null) {
            sqlBuilder.eq("delStatus", (Serializable)delStatus);
        }
        if (GenericsUtils.notNullAndEmpty((Object)(queryList = this.queryList(sqlBuilder)))) {
            return (ReferralInfo)queryList.get(0);
        }
        return null;
    }

    @Override
    public List<ReferralInfo> listReferrals(Integer status, Long orgId, PageInfo pageInfo) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("id", pageInfo.getLastId());
        paramMap.put("orgId", orgId);
        String timeCondition = "";
        if (status.intValue() == ActivityStatus.CLOSED.getCode()) {
            paramMap.put("status", status);
        } else {
            paramMap.put("status", Integer.valueOf(1));
            paramMap.put("curDate", new Date());
            timeCondition = ActivityStatus.UN_START.getCode() == status.intValue() ? " and start_time > :curDate " : (ActivityStatus.END.getCode() == status.intValue() ? " and end_time <= :curDate " : " and start_time <= :curDate and end_time>:curDate ");
        }
        paramMap.put("firstIndex", Integer.valueOf((pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize()));
        paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());
        String sql = null;
        if (pageInfo.getLastId() == null || pageInfo.getLastId() == 0L) {
            sql = "select * from yunying.tx_activity_referral where status = :status and org_id = :orgId and del_status = 0 " + timeCondition + "order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        } else {
            sql = "select * from yunying.tx_activity_referral o1, (select update_time from yunying.tx_activity_referral where id = :id) o2  where status = :status and del_status = 0 AND o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id)) " + timeCondition + " order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";
        }
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<ReferralInfo>>(){

            public List<ReferralInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ReferralInfo> activitys = new ArrayList<ReferralInfo>();
                while (rs.next()) {
                    activitys.add(ReferralDaoImpl.this.toActivity(rs));
                }
                return activitys;
            }
        });
    }

    @Override
    public List<ReferralInfo> selectCurrentReferralList(long orgId) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("orgId", Long.valueOf(orgId));
        paramMap.put("status", Integer.valueOf(1));
        paramMap.put("currentTime", new Date());
        String sql = "select * from yunying.tx_activity_referral where org_id = :orgId and end_time >= :currentTime";
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<ReferralInfo>>(){

            public List<ReferralInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<ReferralInfo> activitys = new ArrayList<ReferralInfo>();
                while (rs.next()) {
                    activitys.add(ReferralDaoImpl.this.toActivity(rs));
                }
                return activitys;
            }
        });
    }

    private ReferralInfo toActivity(ResultSet rs) throws SQLException {
        ReferralInfo activity = new ReferralInfo();
        activity.setActivityId(rs.getLong("id"));
        activity.setTitle(rs.getString("title"));
        activity.setSubTitle(rs.getString("sub_title"));
        activity.setCreateTime(rs.getTimestamp("create_time"));
        activity.setUpdateTime(rs.getTimestamp("update_time"));
        activity.setStartTime(rs.getTimestamp("start_time"));
        activity.setEndTime(rs.getTimestamp("end_time"));
        activity.setOrgId(rs.getLong("org_id"));
        activity.setStatus(rs.getInt("status"));
        activity.setCountLimit(rs.getInt("count_limit"));
        activity.setTemplateId(rs.getLong("template_id"));
        return activity;
    }

    @Override
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id from yunying.tx_activity_referral where org_id in (:orgIds) group by org_id";
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<Long>>(){

            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    orgIds.add(orgId);
                }
                return orgIds;
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getReferralActivityIdsByOrgIds(List<Long> orgIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        String sql = "select org_id, id from yunying.tx_activity_referral where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endTime);
            param.put("startDate", startTime);
        }
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
                while (rs.next()) {
                    List<Long> activityIds;
                    Long orgId = rs.getLong("org_id");
                    Long activityId = rs.getLong("id");
                    if (map.containsKey(orgId)) {
                        activityIds = (List)map.get(orgId);
                        activityIds.add(activityId);
                        continue;
                    }
                    activityIds = new ArrayList();
                    activityIds.add(activityId);
                    map.put(orgId, activityIds);
                }
                return map;
            }
        });
    }
}

