/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.statistic.dao.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxSignupRecordDayDaoImpl
extends JdbcTemplateDaoSupport<TxSignupRecordDay>
implements TxSignupRecordDayDao {
    private static final Logger log = LoggerFactory.getLogger(TxSignupRecordDayDaoImpl.class);

    public TxSignupRecordDayDaoImpl() {
        super(TxSignupRecordDay.class);
    }

    @Override
    public TxSignupRecordDay getByDayType(Long orgId, String mdate, int opType, int opTo, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("mdate", (Serializable)((Object)mdate));
        builder.eq("opType", (Serializable)Integer.valueOf(opType));
        builder.eq("opTo", (Serializable)Integer.valueOf(opTo));
        builder.setMaxSize(Integer.valueOf(1));
        log.debug("getByDayType sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return (TxSignupRecordDay)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TxSignupRecordDay> getListByMonth(int orgId, Date beginTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Integer.valueOf(orgId));
        builder.ge("mdate", (Serializable)beginTime);
        builder.le("mdate", (Serializable)endTime);
        builder.desc("mdate");
        return this.queryList(builder);
    }

    @Override
    public List<TxSignupRecordDay> getListByDate(Integer orgId, Date date) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("mdate", (Serializable)date);
        return this.queryList(builder);
    }

    @Override
    public Integer maxSignupRecordId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxSignupRecordDay> getTxSignupRecordListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", (Serializable)lastDate);
            builder.asc("updateTime");
        } else {
            builder.gt("id", (Serializable)minId);
            builder.asc("id");
        }
        builder.setMaxSize(Integer.valueOf(maxSize));
        log.debug("getTxSignupRecordListByMinId sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public Long getSignupPriceByDay(Long orgId, String mdate, Integer opType) {
        StringBuilder sb = new StringBuilder("select sum(op_price)*100 from yunying.tx_signup_record_day where org_id = :orgId and mdate = :mdate and op_type = :opType and op_to = 1 limit 1");
        HashedMap params = new HashedMap();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType", opType);
        return (Long)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Long.class);
    }
}

