/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.exception.NonUniqueResultException;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupInfoDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupInfo>
implements OrgSignupInfoDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupInfoDaoImpl.class);
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    public OrgSignupInfoDaoImpl() {
        super(OrgSignupInfo.class);
    }

    @Override
    public int countByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public int countByOrgId(Long orgId, int monthDiff) {
        StringBuilder sb = new StringBuilder("select count(1) from yunying.org_signup_info");
        sb.append(" where org_id = :orgId and is_del =:isDel");
        sb.append(" and  date_format(create_time,'%Y-%m')=date_format(DATE_SUB(curdate(), INTERVAL :monthDiff MONTH),'%Y-%m')");
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("isDel", DataStatus.NORMAL.getValue());
        params.put("monthDiff", monthDiff);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Integer.class);
    }

    @Override
    public int countByTime(@NonNull Long orgId, Date startTime, Date endTime) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public int countByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus, @NonNull Collection<Integer> splitResults, Integer cascadeId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (purchaseStatus == null) {
            throw new NullPointerException("purchaseStatus");
        }
        if (splitResults == null) {
            throw new NullPointerException("splitResults");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        log.info("countByPurchaseStatus==sql={}params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        if (cascadeId != null) {
            builder.eq("cascadeId", (Serializable)cascadeId);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Long sumByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus, @NonNull Collection<Integer> splitResults, Integer cascadeId, boolean notCash) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (purchaseStatus == null) {
            throw new NullPointerException("purchaseStatus");
        }
        if (splitResults == null) {
            throw new NullPointerException("splitResults");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("totalPrices");
        builder.eq("orgId", (Serializable)orgId);
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        if (cascadeId != null) {
            builder.eq("cascadeId", (Serializable)cascadeId);
        }
        if (notCash) {
            builder.ne("payType", (Serializable)Integer.valueOf(4));
        }
        Long sum = (Long)this.queryForObject(builder, Long.class);
        log.debug("sumByPurchaseStatus=sql={},params={},{}", new Object[]{builder.toSql(), builder.collectConditionValue(), sum});
        return sum == null ? 0L : sum;
    }

    @Override
    public List<Long> searchPurchaseIdByStudentInfo(@NonNull Long orgId, @NonNull String key, Date startTime, Date endTime) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("signupPurchaseId");
        builder.eq("orgId", (Serializable)orgId);
        builder.or(Expressions.like((String)"studentName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgSignupInfo> getOrgSignupInfo(List<Integer> method, List<Integer> source, Long orgId, Collection<Long> purchaseIds, Collection<Integer> purchaseStatus, Collection<Integer> splitResults, Collection<Integer> payTypes, String key, Date startTime, Date endTime, Integer cascadeId, PageDto page, String ... queryPropes) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryPropes);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            Expression exp = Expressions.or((Expression)Expressions.like((String)"studentName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"mobile", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"signupPurchaseId", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"tradeNo", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            if (CollectionUtils.isNotEmpty(purchaseIds)) {
                exp = Expressions.or((Expression)exp, (Expression)Expressions.in((String)"signupPurchaseId", purchaseIds));
            }
            builder.add(exp);
        }
        if (startTime != null) {
            builder.ge("payTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("payTime", (Serializable)endTime);
        }
        if (cascadeId != null) {
            builder.eq("cascadeId", (Serializable)cascadeId);
        }
        if (method != null && method.size() != 0) {
            builder.in("payType", method);
        } else {
            builder.in("payType", payTypes);
        }
        if (source != null && source.size() != 0) {
            builder.in("sourceType", source);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.desc("createTime");
        builder.setPage(page);
        log.info("getOrgSignupInfo sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> searchByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String ... queryProps) {
        if (purchaseIds == null) {
            throw new NullPointerException("purchaseIds");
        }
        if (purchaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(purchaseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgSignupInfo>>(){

            public List<OrgSignupInfo> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgSignupInfoDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return OrgSignupInfoDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgSignupInfo searchByPurchaseId(@NonNull Long purchaseId, boolean isLock, String ... queryProps) {
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProps);
        builder.desc("createTime");
        builder.eq("signupPurchaseId", (Serializable)purchaseId);
        builder.setMaxSize(Integer.valueOf(1));
        List results = this.getNamedJdbcTemplate().query(builder.toSql(isLock), builder.collectConditionValue(), (RowMapper)new BeanPropertyRowMapper(OrgSignupInfo.class));
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        if (results.size() == 1) {
            return (OrgSignupInfo)((Object)results.get(0));
        }
        throw new NonUniqueResultException(builder.toSql());
    }

    @Override
    public OrgSignupInfo searchByPurchaseId(@NonNull Long purchaseId, String ... queryProps) {
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        return this.searchByPurchaseId(purchaseId, false, queryProps);
    }

    @Override
    public void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getId() != null && signupInfo.getId() > 0L) {
            this.update((Object)signupInfo, new String[0]);
        } else {
            this.save((Object)signupInfo, new String[0]);
        }
    }

    @Override
    public List<OrgSignupInfo> searchHistoryPurchases(Integer purchaseStatus, Date createTime, Integer maxSize) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("purchaseStatus", (Serializable)purchaseStatus);
        builder.gt("create_time", (Serializable)createTime);
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        builder.asc("create_time");
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getPurchases(Long userId, Long orgNumber, Integer payType, Integer purchaseStutus, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("userId", (Serializable)userId);
        if (payType != null) {
            builder.eq("payType", (Serializable)payType);
        }
        builder.eq("purchaseStatus", (Serializable)purchaseStutus);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getPurchases(Date updateTime, Integer purchaseStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.gt("updateTime", (Serializable)updateTime);
        builder.eq("purchaseStatus", (Serializable)purchaseStatus);
        builder.setPage(page);
        builder.desc("updateTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getOrgSignupListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", (Serializable)lastDate);
            builder.asc("updateTime");
        } else {
            builder.gt("id", (Serializable)minId);
            builder.asc("id");
        }
        builder.setMaxSize(Integer.valueOf(maxSize));
        log.debug("getOrgSignupListByMinId sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public int countByTime(List<Long> orgId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgId);
        builder.eq("purchaseStatus", (Serializable)Integer.valueOf(PayStatus.SUCESS.getCode()));
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgSignupInfo> getPurchases(Date startTime, Date endTime, List<Long> orgIds, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.ge("createTime", (Serializable)startTime);
        builder.le("createTime", (Serializable)endTime);
        builder.eq("purchaseStatus", (Serializable)Integer.valueOf(PayStatus.SUCESS.getCode()));
        builder.setPage(page);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public OrgSignupInfo getOrgSignupInfoByUserId(Long orgId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        return null;
    }

    @Override
    public List<OrgSignupInfo> getOrgSignupListByUpdate(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.gt("updateTime", (Serializable)lastDate);
        builder.asc("updateTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("is_del", (Serializable)Integer.valueOf(0));
        builder.eq("org_id", (Serializable)orgId);
        builder.eq("signup_purchase_id", (Serializable)signupPurchaseId);
        log.debug("\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1dgetOrgSignupInfo sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return (OrgSignupInfo)((Object)this.uniqueResult(builder));
    }

    @Override
    public Map<Integer, Integer> countSubOrgByTime(List<Integer> orgId, Date startTime, Date endTime) {
        final HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.in("orgId", orgId);
        builder.group("orgId");
        builder.eq("purchaseStatus", (Serializable)Integer.valueOf(PayStatus.SUCESS.getCode()));
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.put(rs.getInt("orgId"), rs.getInt("num"));
            }
        });
        return data;
    }

    @Override
    public List<OrgSignupInfo> listByStatus(Long orgId, Collection<Integer> purchaseStatus, Collection<Integer> splitResults, Integer cascadeId, boolean notCash, PageDto page, String ... queryPropes) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPropes);
        builder.select(queryPropes);
        builder.eq("orgId", (Serializable)orgId);
        if (cascadeId != null) {
            builder.eq("cascadeId", (Serializable)cascadeId);
        }
        if (notCash) {
            builder.ne("payType", (Serializable)Integer.valueOf(4));
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.desc("payTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> searchSignupInfoWithCourseInfo(List<Integer> splitResult, List<Integer> payResult, List<Integer> payType, Integer signupType, String ... queryPropes) {
        Long purchaseId;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryPropes);
        if (CollectionUtils.isNotEmpty(splitResult)) {
            builder.in("splitResult", splitResult);
        }
        if (CollectionUtils.isNotEmpty(payResult)) {
            builder.in("purchaseStatus", payResult);
        }
        if (CollectionUtils.isNotEmpty(payType)) {
            builder.in("payType", payType);
        }
        if (signupType != null) {
            builder.eq("signupType", (Serializable)signupType);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(0));
        List result = this.queryList(builder);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        ArrayList purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : result) {
            purchaseIds.add(info.getSignupPurchaseId());
        }
        List<OrgSignupCourse> signupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds, new String[0]);
        HashMap signupCourseMaping = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupCourseMaping.get(purchaseId)).add(orgSignupCourse);
        }
        for (OrgSignupInfo orgSignupInfo : result) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupCourses((List)signupCourseMaping.get(purchaseId));
        }
        return result;
    }

    @Override
    public List<OrgSignupInfo> searchByPurchaseIdsWithCourseInfo(@NonNull Collection<Long> purchaseIds, String ... queryProps) {
        Long purchaseId;
        if (purchaseIds == null) {
            throw new NullPointerException("purchaseIds");
        }
        List<OrgSignupInfo> result = this.searchByPurchaseIds(purchaseIds, queryProps);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        List<OrgSignupCourse> signupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds, new String[0]);
        HashMap signupCourseMaping = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList());
            }
            ((List)signupCourseMaping.get(purchaseId)).add(orgSignupCourse);
        }
        for (OrgSignupInfo orgSignupInfo : result) {
            purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) continue;
            orgSignupInfo.setOrgSignupCourses((List)signupCourseMaping.get(purchaseId));
        }
        return result;
    }

    @Override
    public List<Long> getSignupFailPurchaseId() {
        StringBuilder sb = new StringBuilder("select signup_purchase_id from yunying.org_signup_info where purchase_status=1 and user_id = 0 and signup_purchase_id in (select signup_purchase_id from yunying.org_signup_course )");
        return this.getNamedJdbcTemplate().queryForList(sb.toString(), (Map)new HashedMap(), Long.class);
    }

    @Override
    public Long getSignupPriceByDay(Long orgId, String mdate, Integer opType) {
        StringBuilder sb = new StringBuilder("select sum(total_prices) from yunying.org_signup_info where purchase_status=1 and split_result =1 and org_id = :orgId and date_format(pay_time,'%Y-%m-%d') = :mdate and source_type = :opType limit 1");
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType", opType);
        return (Long)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Long.class);
    }

    @Override
    public Integer countSignupPriceByDay(Long orgId, String mdate, Integer opType) {
        StringBuilder sb = new StringBuilder("select count(total_prices) from yunying.org_signup_info where purchase_status=1 and split_result =1 and org_id = :orgId and date_format(pay_time,'%Y-%m-%d') = :mdate and source_type = :opType limit 1");
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType", opType);
        return (Integer)this.getNamedJdbcTemplate().queryForObject(sb.toString(), (Map)params, Integer.class);
    }

    @Override
    public List<OrgSignupInfo> getSignupSuccessAndNotSync() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("splitResult", (Serializable)Integer.valueOf(1));
        builder.eq("purchaseStatus", (Serializable)Integer.valueOf(1));
        builder.eq("smsSend", (Serializable)Integer.valueOf(0));
        builder.le("updateTime", (Serializable)DateUtil.getDiffDateTime((Date)new Date(), (int)-5, (int)12));
        return this.queryList(builder);
    }

    @Override
    public void updateSignupSmsStatus(Long id, Date updateTime) {
        StringBuilder sb = new StringBuilder("update yunying.org_signup_info set sms_send = 1,update_time=:updateTime where id = :id");
        HashedMap params = new HashedMap();
        params.put("id", id);
        params.put("updateTime", updateTime);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
    }

    @Override
    public void updateSignupFinanceStatus(Long id, Date updateTime) {
        StringBuilder sb = new StringBuilder("update yunying.org_signup_info set finance_sync = 1,update_time=:updateTime where id = :id");
        HashedMap params = new HashedMap();
        params.put("id", id);
        params.put("updateTime", updateTime);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
    }
}

