/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CustomFieldDaoImpl
extends JdbcTemplateDaoSupport<CustomField>
implements CustomFieldDao {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldDaoImpl.class);

    @Override
    public List<CustomField> getCustomFieldList(Long orgId, Integer isSystem) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (isSystem != null) {
            if (isSystem.intValue() == AddType.NOT_SYSTEM.getCode()) {
                builder.eq("systemFieldNum", (Serializable)Integer.valueOf(-1));
            } else {
                builder.gt("systemFieldNum", (Serializable)Integer.valueOf(-1));
            }
        }
        builder.desc("sorted");
        return this.queryList(builder);
    }

    @Override
    public List<CustomField> getCustomFieldListWithCondition(Long orgId, Boolean isPaused) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (isPaused != null) {
            builder.eq("isPaused", (Serializable)Integer.valueOf(isPaused != false ? 1 : 0));
        }
        builder.desc("sorted");
        return this.queryList(builder);
    }

    @Override
    public CustomField getCustomFieldById(Long orgId, Long fieldId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.eq("id", (Serializable)fieldId);
        return (CustomField)this.uniqueResult(builder);
    }

    @Override
    public List<CustomField> getCustomFieldsByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        return this.queryList(builder);
    }

    @Override
    public boolean hasInitSystemField(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("systemFieldNum", (Serializable)Integer.valueOf(-1));
        builder.count("id");
        Integer queryForObject = (Integer)this.queryForObject(builder, Integer.class);
        log.info("[CustomFieldDaoImpl] \u7cfb\u7edf\u5b57\u6bb5\u4e2a\u6570 queryForObject param:{}", (Object)queryForObject);
        boolean hasInitSystemField = true;
        if (queryForObject == null || queryForObject == 0) {
            hasInitSystemField = false;
        }
        return hasInitSystemField;
    }

    @Override
    public void batchInsert(List<CustomField> generatorCustomFields) {
        this.saveAll(generatorCustomFields, new String[0]);
    }
}

