/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Entity
@Table(name="org_storage", catalog="yunying")
public class OrgStorage {
    @Id
    @GeneratedValue
    private Integer id;
    @Column(name="fid")
    private String fid;
    @Column(name="sn")
    private String sn;
    @Column(name="size")
    private Integer size;
    @Column(name="mimetype")
    private Integer mimeType;
    @Column(name="createtime")
    private Date createTime;
    @Column(name="updatetime")
    private Date updateTime;
    @Column(name="isdel")
    private Integer isDel;
    @Column(name="source")
    private Short source;

    public String getUrl(String imgServer) {
        String fmt = "%s%s_%s.%s";
        return String.format(fmt, imgServer, this.fid, this.sn, MIMEType.getExtension(this.getMimeType()));
    }

    public static String parseSn(String url) {
        url = url.substring(url.lastIndexOf("/") + 1, url.length());
        Pattern pattern = Pattern.compile("_([^.]*)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String parseFid(String url) {
        url = url.substring(url.lastIndexOf("/") + 1, url.length());
        Pattern pattern = Pattern.compile("([^_]*)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Integer parseMimetype(String url) {
        url = url.substring(url.lastIndexOf("/") + 1, url.length());
        Pattern pattern = Pattern.compile("\\.(.*)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String extension = matcher.group(1);
            return MIMEType.getCode(extension);
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "http://test-img.gsxservice.com/727673_7elqq65c.jpg";
        System.out.println(OrgStorage.parseSn(url));
        System.out.println(OrgStorage.parseFid(url));
        System.out.println(OrgStorage.parseMimetype(url));
    }

    public Integer getId() {
        return this.id;
    }

    public String getFid() {
        return this.fid;
    }

    public String getSn() {
        return this.sn;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getMimeType() {
        return this.mimeType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public Short getSource() {
        return this.source;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setMimeType(Integer mimeType) {
        this.mimeType = mimeType;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }

    public void setSource(Short source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgStorage)) {
            return false;
        }
        OrgStorage other = (OrgStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$fid = this.getFid();
        String other$fid = other.getFid();
        if (this$fid == null ? other$fid != null : !this$fid.equals(other$fid)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Integer this$mimeType = this.getMimeType();
        Integer other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !((Object)this$mimeType).equals(other$mimeType)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Integer this$isDel = this.getIsDel();
        Integer other$isDel = other.getIsDel();
        if (this$isDel == null ? other$isDel != null : !((Object)this$isDel).equals(other$isDel)) {
            return false;
        }
        Short this$source = this.getSource();
        Short other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $fid = this.getFid();
        result = result * 59 + ($fid == null ? 43 : $fid.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Integer $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : ((Object)$mimeType).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Integer $isDel = this.getIsDel();
        result = result * 59 + ($isDel == null ? 43 : ((Object)$isDel).hashCode());
        Short $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        return result;
    }

    public String toString() {
        return "OrgStorage(id=" + this.getId() + ", fid=" + this.getFid() + ", sn=" + this.getSn() + ", size=" + this.getSize() + ", mimeType=" + this.getMimeType() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", isDel=" + this.getIsDel() + ", source=" + this.getSource() + ")";
    }
}

