/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="orgCourseGroupRelateDao")
public class OrgCourseGroupRelateDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseGroupRelate>
implements OrgCourseGroupRelateDao {
    private static final Logger logger = LoggerFactory.getLogger(OrgCourseGroupRelateDaoImpl.class);

    public OrgCourseGroupRelateDaoImpl() {
        super(OrgCourseGroupRelate.class);
    }

    @Override
    public List<OrgCourseGroupRelate> getOrgCourseGroup(Integer orgId, PageDto pageDto) {
        String sql = "select oc.* from org_course_group og,org_course_group_relate oc where og.org_id=? and og.id=oc.course_group_id and oc.is_deleted=1 and course_type!=0 order by oc.display_order desc";
        return this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgId}, (RowMapper)BeanPropertyRowMapper.newInstance(OrgCourseGroupRelate.class));
    }

    @Override
    public List<Long> getCourseIdsByGroup(Integer courseGroupId, Integer courseType) {
        try {
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.select("courseId");
            builder.eq("courseGroupId", (Serializable)courseGroupId);
            builder.eq("courseType", (Serializable)courseType);
            builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            builder.desc("displayOrder");
            return this.queryForList(builder, Long.class);
        }
        catch (Exception e) {
            logger.info("courseGroupId:{}, courseType:{}, e:{}", new Object[]{courseGroupId, courseType, e});
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<Long> getCourseIdsByGroups(Collection<Integer> courseGroupIds, Integer courseType) {
        if (courseGroupIds == null) {
            return null;
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"courseGroupId"});
        builder.select("courseId");
        builder.in("courseGroupId", courseGroupIds);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("displayOrder");
        List list = this.queryList(builder);
        return CollectorUtil.collect((Collection)list, (Function)new Function<OrgCourseGroupRelate, Long>(){

            public Long apply(OrgCourseGroupRelate input) {
                return input.getCourseId();
            }
        });
    }

    @Override
    public OrgCourseGroupRelate getCourseGroupByCourseId(Integer courseGroupId, Integer courseType, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("courseGroupId", (Serializable)courseGroupId);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgCourseGroupRelate)this.uniqueResult(builder);
    }

    @Override
    public void deleteGroupOfCourse(Long courseId, Collection<Integer> groupIds, Integer courseType) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return;
        }
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("courseId", courseId);
        updateCondtion.put("courseGroupId", groupIds);
        updateCondtion.put("courseType", courseType);
        OrgCourseGroupRelate obj = new OrgCourseGroupRelate();
        obj.setIsDeleted(DeleteStatus.DELETED.getValue());
        this.update(updateCondtion, false, obj, new String[]{"isDeleted"});
    }

    @Override
    public List<Integer> getGroupIdByCourseId(Long courseId, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("courseGroupId");
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryForList(builder, Integer.class);
    }

    @Override
    public List<OrgCourseGroupRelate> getGroupByCourseId(Long courseId, Integer courseType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("courseId", (Serializable)courseId);
        builder.eq("courseType", (Serializable)courseType);
        builder.eq("isDeleted", (Serializable)courseType);
        return this.queryList(builder);
    }

    @Override
    public int getMaxDisplayOrderByExcludeIds(Integer courseGroupId, Collection<Long> excludeIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("displayOrder");
        builder.eq("courseGroupId", (Serializable)courseGroupId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.notin("courseId", excludeIds);
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public void batchAddWeike(Long groupId, Collection<Long> courseIds) {
        Preconditions.checkArgument((groupId != null ? 1 : 0) != 0, (Object)"groupid == null");
        logger.info("batchAddWeike:{}  {}", (Object)groupId, courseIds);
        if (CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        for (Long courseId : courseIds) {
            OrgCourseGroupRelate relate = this.getCourseGroupByCourseId(groupId.intValue(), CourseType.ORG_COURSE.getCode(), courseId);
            if (relate != null) continue;
            OrgCourseGroupRelate po = new OrgCourseGroupRelate();
            po.setCourseGroupId(groupId.intValue());
            po.setCourseId(courseId);
            po.setCourseType(CourseType.ORG_COURSE.getCode());
            po.setCreateTime(new Date());
            po.setIsDeleted(DeleteStatus.NORMAL.getValue());
            po.setDisplayOrder(0);
            this.save(po, new String[0]);
        }
    }

    @Override
    public boolean isRecommendTeacher(long teacherId) {
        String sql = "select count(*) from yunying.org_recommend_teacher where teacher_id = :teacherId and is_deleted = :isDel";
        HashMap map = Maps.newHashMap();
        map.put("teacherId", teacherId);
        map.put("isDel", DeleteStatus.NORMAL.getValue());
        int num = (Integer)this.getNamedJdbcTemplate().queryForObject(sql, (Map)map, Integer.class);
        return num > 0;
    }

    @Override
    public Map<Long, Integer> isRecommendTeacher(Collection<Long> teacherIds) {
        if (teacherIds == null || teacherIds.size() == 0) {
            return Maps.newHashMap();
        }
        String sql = "select count(id) as cc,teacher_id as tid from yunying.org_recommend_teacher where teacher_id in (:teacherIds) and is_deleted = :isDel";
        HashMap map = Maps.newHashMap();
        map.put("teacherIds", teacherIds);
        map.put("isDel", DeleteStatus.NORMAL.getValue());
        return (Map)this.getNamedJdbcTemplate().query(sql, (Map)map, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long tid = rs.getLong("tid");
                    Integer cc = rs.getInt("cc");
                    map.put(tid, cc);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgCourseGroupRelate> getCourseGroupRelateByGroupIds(List<Integer> ids, int code) {
        try {
            if (ids == null) {
                return null;
            }
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.in("courseGroupId", ids);
            builder.eq("courseType", (Serializable)Integer.valueOf(code));
            builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            builder.desc("displayOrder");
            List list = this.queryList(builder);
            return list;
        }
        catch (Exception e) {
            logger.debug("000", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<OrgCourseGroupRelate> getCourseGroupRelateByCourseIds(List<Integer> ids, int courseType) {
        try {
            if (ids == null) {
                return null;
            }
            SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
            builder.in("course_id", ids);
            builder.eq("courseType", (Serializable)Integer.valueOf(courseType));
            builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            builder.desc("displayOrder");
            List list = this.queryList(builder);
            return list;
        }
        catch (Exception e) {
            logger.debug("000", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

