/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CallServiceInfoDaoImpl
extends JdbcTemplateDaoSupport<CallServiceInfo>
implements CallServiceInfoDao {
    public CallServiceInfoDaoImpl() {
        super(CallServiceInfo.class);
    }

    @Override
    public Map<String, Object> queryCallCountAndTime(String mobile, Long callParty, PartyCallType callType) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be null");
        Preconditions.checkArgument((callParty != null && callParty > 0L ? 1 : 0) != 0, (Object)"call party is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.max("createTime", "MAX_TIME");
        builder.eq("callSubscriberNum", (Serializable)((Object)mobile));
        builder.eq("calledParty", (Serializable)callParty);
        if (callType != null) {
            builder.eq("callType", (Serializable)Integer.valueOf(callType.getCode()));
        }
        return this.getNamedJdbcTemplate().queryForMap(builder.toSql(), builder.collectConditionValue());
    }

    @Override
    public Integer getTotalDurationByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("duration");
        builder.eq("callSubscriber", (Serializable)Long.valueOf(orgId.intValue()));
        builder.eq("month", (Serializable)((Object)DateUtil.getCurrentYM()));
        Integer sum = (Integer)this.queryForObject(builder, Integer.class);
        if (sum == null) {
            return 0;
        }
        return sum;
    }

    @Override
    public List<CallServiceInfo> listCallServiceInfoDesc(Integer orgId, String mobile, PageDto pageDto) {
        final ArrayList<CallServiceInfo> list = new ArrayList<CallServiceInfo>();
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT * FROM yunying.callservice_info ").append(" WHERE (call_subscriber=:orgId AND call_subscriber_num=:mobile) ").append(" OR (called_party=:orgId AND called_party_num=:mobile)");
        builder.append(" ORDER BY id DESC");
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("mobile", mobile);
        if (pageDto != null) {
            params.put("start", pageDto.firstNum());
            params.put("size", pageDto.getPageSize());
        }
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            CallServiceInfo info;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.info = new CallServiceInfo();
                this.info.setCallback(rs.getString("callback"));
                this.info.setCalledParty(rs.getLong("called_party"));
                this.info.setCalledPartyNum(rs.getString("called_party_num"));
                this.info.setCallEnd(rs.getTimestamp("call_end"));
                this.info.setCallStart(rs.getTimestamp("call_start"));
                this.info.setCallSubscriber(rs.getLong("call_subscriber"));
                this.info.setCallSubscriberNum(rs.getString("call_subscriber_num"));
                this.info.setCallType(rs.getInt("call_type"));
                this.info.setCdrStatus(rs.getInt("cdr_status"));
                this.info.setCreateTime(rs.getTimestamp("create_time"));
                this.info.setDuration(rs.getInt("duration"));
                this.info.setId(rs.getLong("id"));
                this.info.setMonth(rs.getString("month"));
                this.info.setResult(rs.getInt("result"));
                this.info.setStorageId(rs.getLong("storage_id"));
                this.info.setUniqueId(rs.getString("unique_id"));
                this.info.setUpdateTime(rs.getTimestamp("update_time"));
                list.add(this.info);
                return 1;
            }
        });
        return list;
    }

    @Override
    public List<CallServiceInfo> page(Long minId, PageDto pageDto) {
        final ArrayList<CallServiceInfo> list = new ArrayList<CallServiceInfo>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.callservice_info WHERE (call_type=2 OR call_type=4)");
        if (minId != null && minId != 0L) {
            builder.append(" AND id>:minId");
        }
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("minId", minId);
        params.put("start", pageDto.firstNum());
        params.put("size", pageDto.getPageSize());
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){
            CallServiceInfo info;

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.info = new CallServiceInfo();
                this.info.setCallback(rs.getString("callback"));
                this.info.setCalledParty(rs.getLong("called_party"));
                this.info.setCalledPartyNum(rs.getString("called_party_num"));
                this.info.setCallEnd(rs.getTimestamp("call_end"));
                this.info.setCallStart(rs.getTimestamp("call_start"));
                this.info.setCallSubscriber(rs.getLong("call_subscriber"));
                this.info.setCallSubscriberNum(rs.getString("call_subscriber_num"));
                this.info.setCallType(rs.getInt("call_type"));
                this.info.setCdrStatus(rs.getInt("cdr_status"));
                this.info.setCreateTime(rs.getTimestamp("create_time"));
                this.info.setDuration(rs.getInt("duration"));
                this.info.setId(rs.getLong("id"));
                this.info.setMonth(rs.getString("month"));
                this.info.setResult(rs.getInt("result"));
                this.info.setStatus(rs.getInt("status"));
                this.info.setStorageId(rs.getLong("storage_id"));
                this.info.setUniqueId(rs.getString("unique_id"));
                this.info.setUpdateTime(rs.getTimestamp("update_time"));
                list.add(this.info);
                return 1;
            }
        });
        return list;
    }

    @Override
    public Map<Long, CallStatisticDto> getTotalDurationAndCount(Date startTime, Date endTime, List<Long> orgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        String sql = "select count(1) count, sum(duration) duration, call_subscriber from yunying.callservice_info where call_subscriber in (:orgIds)";
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            sql = sql + " and create_time between :startTime and :endTime";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + " group by call_subscriber";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, CallStatisticDto>>(){

            public Map<Long, CallStatisticDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, CallStatisticDto> map = new HashMap<Long, CallStatisticDto>();
                while (rs.next()) {
                    Long orgId = rs.getLong("call_subscriber");
                    Integer count = rs.getInt("count");
                    Integer duration = rs.getInt("duration");
                    CallStatisticDto dto = new CallStatisticDto();
                    dto.setCount(count);
                    dto.setDuration(duration);
                    map.put(orgId, dto);
                }
                return map;
            }
        });
    }
}

