/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class TxActivityCommonDaoImpl
extends JdbcTemplateDaoSupport<TxActivityCommon>
implements TxActivityCommonDao {
    @Override
    public List<TxActivityCommon> getTxActivityList(Long orgId, Collection<Integer> typeIds, PageDto pageDto, Integer isSortedByPopular, Integer status) {
        Date curTime = new Date();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.in("templateTypeId", typeIds);
        if (status != null) {
            if (status.intValue() == ActivityStatus.CLOSED.getCode()) {
                builder.eq("status", (Serializable)status);
            } else {
                builder.eq("status", (Serializable)Integer.valueOf(1));
                if (status.intValue() == ActivityStatus.UN_START.getCode()) {
                    builder.gt("startTime", (Serializable)curTime);
                } else if (status.intValue() == ActivityStatus.END.getCode()) {
                    builder.lt("endTime", (Serializable)curTime);
                } else {
                    builder.le("startTime", (Serializable)curTime);
                    builder.ge("endTime", (Serializable)curTime);
                }
            }
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (isSortedByPopular != null && isSortedByPopular == 1) {
            builder.desc("accessCount");
        } else {
            builder.desc("updateTime");
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public TxActivityCommon getTxActivityCommon(Long orgId, Integer typeId, Long activityId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (orgId != null) {
            builder.eq("orgId", (Serializable)orgId);
        }
        builder.eq("activityId", (Serializable)activityId);
        builder.eq("templateTypeId", (Serializable)typeId);
        return (TxActivityCommon)this.uniqueResult(builder);
    }

    @Override
    public Integer getActivityTotal(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxActivityCommon> selectUnEndedActivityList(long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.gt("endTime", (Serializable)new Date());
        builder.setOrder(Order.desc((String[])new String[]{"createTime"}));
        return this.queryList(builder);
    }
}

