/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TxMonitorTypeDayDaoImpl
extends JdbcTemplateDaoSupport<TxMonitorTypeDay>
implements TxMonitorTypeDayDao {
    private static final Logger log = LoggerFactory.getLogger(TxMonitorTypeDayDaoImpl.class);

    public TxMonitorTypeDayDaoImpl() {
        super(TxMonitorTypeDay.class);
    }

    @Override
    public List<TxMonitorTypeDay> listTypeDay(Long orgNumber, Date startDate, Date endDate, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.sum("pv", "pv");
        builder.sum("uv", "uv");
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.ge("mdate", (Serializable)startDate);
        builder.lt("mdate", (Serializable)endDate);
        builder.group("pageType");
        return this.queryList(builder, TxMonitorTypeDay.class);
    }

    @Override
    public List<TxMonitorTypeDay> listUseMonitorType(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("pv", "pv");
        builder.sum("uv", "uv");
        builder.in("orgNumber", TianxiaoOrgNumbers);
        builder.group("orgNumber");
        if (startDate != null && endDate != null) {
            builder.between("mdate", (Comparable)startDate, (Comparable)endDate);
        }
        return this.queryList(builder, TxMonitorTypeDay.class);
    }

    @Override
    public Map<String, TxMonitorTypeDay> mapUseMonitorType(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        String sql = "select sum(pv) pv, sum(uv) uv, DATE_FORMAT(mdate,'%y-%m-%d') 'mdate' from yunying.tx_monitor_type_day where org_number in (:orgNumbers) and mdate between :startDate and :endDate group by MONTH(mdate),DAY(mdate)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, TxMonitorTypeDay>>(){

            public Map<String, TxMonitorTypeDay> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, TxMonitorTypeDay> map = new HashMap<String, TxMonitorTypeDay>();
                while (rs.next()) {
                    TxMonitorTypeDay txMonitorTypeDay = new TxMonitorTypeDay();
                    String date = rs.getString("mdate");
                    txMonitorTypeDay.setPv(rs.getInt("pv"));
                    txMonitorTypeDay.setUv(rs.getInt("uv"));
                    log.info("mdate===========" + rs.getString("mdate") + "count==========" + rs.getInt("pv"));
                    map.put(date, txMonitorTypeDay);
                }
                return map;
            }
        });
    }
}

