/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.AutoMatchUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class TxConsultUserDaoImpl
extends JdbcTemplateDaoSupport<TxConsultUser>
implements TxConsultUserDao {
    private static final Logger log = LoggerFactory.getLogger(TxConsultUserDaoImpl.class);

    public TxConsultUserDaoImpl() {
        super(TxConsultUser.class);
    }

    @Override
    public List<TxConsultUser> lookByUserId(Long orgId, Long useId, String ... queryProp) {
        if (useId == null || useId == 0L) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("userId", (Serializable)useId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByStudentId(Long orgId, Long studentId, String ... queryProp) {
        if (studentId == null || studentId == 0L) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("studentId", (Serializable)studentId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByMobile(Long orgId, String mobile, String ... queryProp) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByWeixinOpenId(Long orgId, String weixinOpenId, String ... queryProp) {
        if (StringUtils.isBlank((CharSequence)weixinOpenId)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByMobiles(final Long orgId, Collection<String> mobiles, final String ... queryProp) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, List<TxConsultUser>>(){

            public List<TxConsultUser> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = TxConsultUserDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("mobile", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                return TxConsultUserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<TxConsultUser> lookByWeixinOpenIds(final Long orgId, Collection<String> weixinOpenIds, final String ... queryProp) {
        if (CollectionUtils.isEmpty(weixinOpenIds)) {
            return Collections.emptyList();
        }
        return (List)new ListBatchQueryTemplate().batchQuery(weixinOpenIds, (BatchQueryCallback)new BatchQueryCallback<String, List<TxConsultUser>>(){

            public List<TxConsultUser> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = TxConsultUserDaoImpl.this.createSqlBuilder(queryProp);
                builder.in("mobile", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                return TxConsultUserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<TxConsultUser> search(Integer type, String key, Long orgId, Integer casCadeId, Integer intensionLevel, Collection<Integer> consultSources, Date startTime, Date endTime, PageDto page, String ... queryProp) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((type == null || type != null && (type == 0 || type == 1) ? 1 : 0) != 0, (Object)"type is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        if (type != null) {
            if (0 == type) {
                builder.eq("studentId", (Serializable)Integer.valueOf(0));
            } else if (1 == type) {
                builder.gt("studentId", (Serializable)Integer.valueOf(0));
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
            Expression exp = Expressions.like((String)"name", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE);
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"nickName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"weixinNickName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            if (StringUtils.isNumeric((CharSequence)key)) {
                exp = Expressions.or((Expression)exp, (Expression)Expressions.like((String)"mobile", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE));
            }
            builder.add(exp);
        }
        if (intensionLevel != null) {
            builder.eq("intensionLevel", (Serializable)intensionLevel);
        }
        if (CollectionUtils.isNotEmpty(consultSources)) {
            builder.in("consultSource", consultSources);
        }
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.ge("createTime", (Serializable)endTime);
        }
        if (casCadeId != null) {
            builder.eq("cascadeId", (Serializable)casCadeId);
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(page);
        builder.desc("createTime");
        log.info("SQL is : ======== ", (Object)builder.toSql());
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getOrgConsultUserListByMinId(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.asc("createTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getOrgConsultUserListByUpdateTime(Long minId, Date lastDate, int maxSize, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.gt("updateTime", (Serializable)lastDate);
        builder.asc("updateTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public Map<String, TxConsultUser> mapKeyOpenIdValueId(Integer orgId, List<String> openIdList) {
        final HashMap<String, TxConsultUser> map = new HashMap<String, TxConsultUser>();
        String sql = "SELECT * FROM yunying.tx_consult_user WHERE org_id=:orgId AND weixin_open_id IN(:openIdList) AND del_status=0";
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("openIdList", openIdList);
        template.query(sql, params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                TxConsultUser user = new TxConsultUser();
                user.setId(rs.getLong("id"));
                user.setIsConsulter(rs.getInt("is_consulter"));
                user.setUserId(rs.getLong("user_id"));
                user.setOrgId(rs.getLong("org_id"));
                user.setUserId(rs.getLong("user_id"));
                user.setIsInvalid(rs.getInt("is_invalid"));
                user.setKefuId(rs.getLong("kefu_id"));
                map.put(rs.getString("weixin_open_id"), user);
                return 1;
            }
        });
        return map;
    }

    @Override
    public List<TxConsultUser> getConsultUserByRemindTime(Date startTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)new Date());
        builder.gt("nextRemindTime", (Serializable)startTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> getConsultUserByRemindTime(Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)endTime);
        builder.ge("nextRemindTime", (Serializable)startTime);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public TxConsultUser getOrgConsultUser(Long orgId, Long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)id);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TxConsultUser)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("mobile", (Serializable)((Object)""));
        builder.dateformat("birthday", format, value);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.group("mobile");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<TxConsultUser> lookByParams(Long orgId, String weixinOpenId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public TxConsultUser lookByParams(Long orgId, String mobile, String weixinOpenId, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("weixinOpenId", (Serializable)((Object)weixinOpenId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TxConsultUser)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TxConsultUser> searchConsultByCustomParam(long orgId, AutoMatchQueryRequest params, Integer cascadeId, Integer isInvalid, List<Long> inConsultUserIds, List<Long> notInConsultUserIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.le("studentId", (Serializable)Integer.valueOf(0));
        log.debug("AutoMatchQueryRequest clue=={}", (Object)params);
        if (params != null || params != null && params.getPropName() != null && !params.getPropName().equals("tag")) {
            AutoMatchUtils.wrap(builder, params);
        } else {
            builder.desc("id");
        }
        if (cascadeId != null) {
            if (cascadeId == -2) {
                builder.ge("cascadeId", (Serializable)Integer.valueOf(0));
            } else {
                builder.eq("cascadeId", (Serializable)cascadeId);
            }
        }
        if (isInvalid != null) {
            builder.eq("isInvalid", (Serializable)isInvalid);
        }
        if (inConsultUserIds != null && inConsultUserIds.size() > 0) {
            builder.in("id", inConsultUserIds);
        }
        if (notInConsultUserIds != null && notInConsultUserIds.size() > 0) {
            builder.notin("id", notInConsultUserIds);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        builder.eq("isConsulter", (Serializable)Integer.valueOf(Flag.TRUE.getInt()));
        log.debug("searchConsultByCustomParam :builder sql = {},param={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public void refreshConsultUser(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.tx_consult_user set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public Map<Long, Integer> getConsultUserTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.tx_consult_user where org_id in (:orgIds)";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate ";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + "group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, TxConsultUser> getConsultUserByIds(Long orgId, Set<Long> ids) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", ids);
        param.put("orgId", orgId);
        String sql = "select * from yunying.tx_consult_user where id in (:ids) and del_status = 0 and org_id = :orgId ";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, TxConsultUser>>(){

            public Map<Long, TxConsultUser> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, TxConsultUser> map = new HashMap<Long, TxConsultUser>();
                while (rs.next()) {
                    Long consultId = rs.getLong("id");
                    TxConsultUser TxConsultUser2 = TxConsultUserDaoImpl.this.getInstance(rs);
                    map.put(consultId, TxConsultUser2);
                }
                return map;
            }
        });
    }

    private TxConsultUser getInstance(ResultSet rs) throws SQLException {
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser.setId(rs.getLong("id"));
        txConsultUser.setOrgId(rs.getLong("org_id"));
        txConsultUser.setUserId(rs.getLong("user_id"));
        txConsultUser.setStudentId(rs.getLong("student_id"));
        txConsultUser.setName(rs.getString("name"));
        txConsultUser.setNickName(rs.getString("nick_name"));
        txConsultUser.setSchool(rs.getString("school"));
        txConsultUser.setMobile(rs.getString("mobile"));
        txConsultUser.setWeixin(rs.getString("weixin"));
        txConsultUser.setWeixinOpenId(rs.getString("weixin_open_id"));
        txConsultUser.setWeixinAppId(rs.getString("weixin_app_id"));
        txConsultUser.setConsultSource(rs.getInt("consult_source"));
        txConsultUser.setConsultStatus(rs.getInt("consult_status"));
        txConsultUser.setPortrait(rs.getString("portrait"));
        txConsultUser.setPinyin(rs.getString("pinyin"));
        txConsultUser.setIsConsulter(rs.getInt("is_consulter"));
        txConsultUser.setIntensionLevel(rs.getInt("intension_level"));
        txConsultUser.setNextRemindTime(rs.getTimestamp("next_remind_time"));
        txConsultUser.setCreateTime(rs.getTimestamp("create_time"));
        return txConsultUser;
    }

    @Override
    public Map<Long, Long> getUserIdMapByIds(Long orgId, Set<Long> ids) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", ids);
        param.put("orgId", orgId);
        String sql = "select * from yunying.tx_consult_user where id in (:ids) and del_status = 0 and org_id = :orgId and user_id != 0";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Long>>(){

            public Map<Long, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                while (rs.next()) {
                    Long consultId = rs.getLong("id");
                    Long userId = rs.getLong("user_id");
                    map.put(consultId, userId);
                }
                return map;
            }
        });
    }

    @Override
    public Integer statisticTotalConsultByCondition(Long orgId, Integer isConsulter, List<Integer> followStatuss, List<Integer> intentionLevels, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("isConsulter", (Serializable)isConsulter);
        builder.eq("orgId", (Serializable)orgId);
        if (GenericsUtils.notNullAndEmpty(followStatuss)) {
            builder.in("consultStatus", followStatuss);
        }
        if (GenericsUtils.notNullAndEmpty(intentionLevels)) {
            builder.in("intensionLevel", intentionLevels);
        }
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            builder.ge("createTime", (Serializable)startTime);
            builder.lt("createTime", (Serializable)endTime);
        }
        log.info("build = ", (Object)builder);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxConsultUser> searchConsultUsersByCondition(Long orgId, Integer isConsulter, List<Integer> followStatuss, List<Integer> intentionLevels, Date startTime, Date endTime, Integer start, Integer limit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("isConsulter", isConsulter);
        param.put("orgId", orgId);
        String sql = "select * from yunying.tx_consult_user where is_consulter = :isConsulter and del_status = 0 and org_id = :orgId ";
        if (GenericsUtils.notNullAndEmpty(followStatuss)) {
            sql = sql + "and consult_status in (:followStatuss) ";
            param.put("followStatuss", followStatuss);
        }
        if (GenericsUtils.notNullAndEmpty(intentionLevels)) {
            sql = sql + "and intension_level in (:intentionLevels)";
            param.put("intentionLevels", intentionLevels);
        }
        if (GenericsUtils.notNullAndEmpty((Object)startTime)) {
            sql = sql + " and create_time >= :startTime and create_time < :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        if (GenericsUtils.notNullAndEmpty((Object)start)) {
            sql = sql + "limit :start, :limit";
            param.put("start", start);
            param.put("limit", limit);
        }
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<TxConsultUser>>(){

            public List<TxConsultUser> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<TxConsultUser> list = new ArrayList<TxConsultUser>();
                while (rs.next()) {
                    TxConsultUser txConsultUsr = TxConsultUserDaoImpl.this.getInstance(rs);
                    log.info("txConsultUsr param:{}", (Object)txConsultUsr);
                    list.add(txConsultUsr);
                }
                return list;
            }
        });
    }

    @Override
    public TxConsultUser getOrgConsultUser(Long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)id);
        return (TxConsultUser)((Object)this.uniqueResult(builder));
    }

    @Override
    public Integer countConsulter(Long orgId, Long cascadeId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("cascadeId", (Serializable)cascadeId);
        builder.eq("studentId", (Serializable)Integer.valueOf(0));
        builder.eq("isConsulter", (Serializable)Integer.valueOf(Flag.TRUE.getInt()));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count != null ? count : 0;
    }

    @Override
    public List<TxConsultUser> getPageTxConsultUsersByIds(Collection<Long> ids, Integer start, Integer limit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("consultIds", ids);
        String sql = "select * from yunying.tx_consult_user where id in (:consultIds) ";
        if (GenericsUtils.notNullAndEmpty((Object)start)) {
            sql = sql + "limit :start, :limit";
            param.put("start", start);
            param.put("limit", limit);
        }
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<TxConsultUser>>(){

            public List<TxConsultUser> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<TxConsultUser> list = new ArrayList<TxConsultUser>();
                while (rs.next()) {
                    TxConsultUser txConsultUsr = TxConsultUserDaoImpl.this.getInstance(rs);
                    log.info("txConsultUsr param:{}", (Object)txConsultUsr);
                    list.add(txConsultUsr);
                }
                return list;
            }
        });
    }

    @Override
    public List<TxConsultUser> getPageTxConsultUserByStudentIds(final Long orgId, Collection<Long> studentIds, final PageDto pageDto) {
        if (studentIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List txConsultUsers = (List)queryTemplate.batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<TxConsultUser>>(){

            public List<TxConsultUser> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = TxConsultUserDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("studentId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                builder.setPage(pageDto);
                return TxConsultUserDaoImpl.this.queryList(builder);
            }
        });
        return txConsultUsers;
    }

    @Override
    public List<TxConsultUser> batchTxConsultUserByIds(Collection<Long> ids, Integer delStatus, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        if (GenericsUtils.notNullAndEmpty((Object)delStatus)) {
            builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        }
        if (status != null && status.intValue() == EncrollmentTypeEnum.ZIXUN.getValue()) {
            builder.eq("isConsulter", (Serializable)Integer.valueOf(ConsulterStatus.NOT.getValue()));
        }
        return this.queryList(builder);
    }

    @Override
    public List<Long> listConsulterUserIdsNeedToRelease(Date releaseTime) {
        HashMap<String, Comparable<Date>> param = new HashMap<String, Comparable<Date>>();
        param.put("releaseTime", releaseTime);
        param.put("cascadeId", Integer.valueOf(Flag.NULL.getInt()));
        param.put("delStatus", Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        String sql = "SELECT * FROM yunying.tx_consult_user WHERE finally_hold_time<=:releaseTime AND cascade_id!=:cascadeId AND del_status=:delStatus";
        List result = (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<Long>>(){

            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Long> list = new ArrayList<Long>();
                while (rs.next()) {
                    list.add(rs.getLong("id"));
                }
                return list;
            }
        });
        return result;
    }

    @Override
    public int release(List<Long> ids, Date releaseTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", ids);
        param.put("cascadeId", Flag.NULL.getInt());
        param.put("releaseTime", releaseTime);
        String sql = "UPDATE yunying.tx_consult_user SET cascade_id=:cascadeId,last_push_time=:releaseTime WHERE id IN (:ids)";
        return this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public List<Long> listConsulterUserIdsByCascade(Long cascadeId) {
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("cascadeId", cascadeId);
        param.put("delStatus", DeleteStatus.NORMAL.getValue());
        String sql = "SELECT * FROM yunying.tx_consult_user WHERE cascade_id=:cascadeId AND del_status=:delStatus";
        List result = (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<Long>>(){

            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Long> list = new ArrayList<Long>();
                while (rs.next()) {
                    list.add(rs.getLong("id"));
                }
                return list;
            }
        });
        return result;
    }

    @Override
    public List<TxConsultUser> getUsersByPage(PageDto pageDto) {
        String sql = "select id,org_id,mobile from yunying.tx_consult_user WHERE student_id = 0 and del_status=0 limit :start,:size";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        map.put("size", pageDto.getPageSize());
        return this.getNamedJdbcTemplate().query(sql, map, (RowMapper)new RowMapper<TxConsultUser>(){

            public TxConsultUser mapRow(ResultSet rs, int rowNum) throws SQLException {
                TxConsultUser user = new TxConsultUser();
                user.setId(rs.getLong("id"));
                user.setMobile(rs.getString("mobile"));
                user.setOrgId(rs.getLong("org_id"));
                return user;
            }
        });
    }

    @Override
    public Integer countBySource(Long orgId, Long sourceId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("consultSource", (Serializable)sourceId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public void replacePortrait(String oldUrl, String newUrl) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("portrait", (Serializable)((Object)oldUrl));
        builder.count("id");
        if ((Integer)this.queryForObject(builder, Integer.class) > 0) {
            StringBuilder sb = new StringBuilder("UPDATE yunying.tx_consult_user SET portrait =:newUrl WHERE portrait =:oldUrl");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("oldUrl", oldUrl);
            param.put("newUrl", newUrl);
            this.getNamedJdbcTemplate().update(sb.toString(), param);
        }
    }

    @Override
    public List<TxConsultUser> listOpenIdNotNull(Long minId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("weixinOpenId", (Serializable)((Object)""));
        builder.gt("id", (Serializable)minId);
        return this.queryList(builder);
    }
}

