/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class TXAccountDaoImpl
extends JdbcTemplateDaoSupport<TXAccount>
implements TXAccountDao {
    public TXAccountDaoImpl() {
        super(TXAccount.class);
    }

    @Override
    public TXAccount getByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)id);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, TXAccount> getAccountTypeMap(Collection<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        List txAccontList = this.queryList(builder);
        HashMap<Long, TXAccount> txAccountMap = new HashMap<Long, TXAccount>();
        if (txAccontList != null && txAccontList.size() > 0) {
            for (TXAccount txAccount : txAccontList) {
                txAccountMap.put(txAccount.getOrgId().longValue(), txAccount);
            }
        }
        return txAccountMap;
    }
}

