/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.finance.dao.impl;

import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxFinanceInfoDaoImpl
extends JdbcTemplateDaoSupport<TxxFinanceInfo>
implements TxFinanceInfoDao {
    private static final Logger log = LoggerFactory.getLogger(TxFinanceInfoDaoImpl.class);

    @Override
    public List<TxxFinanceInfo> list(TxxFinanceInfo txFinanceInfo, String key, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", (Serializable)txFinanceInfo.getOrgId());
        if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)key.trim())) {
            builder.like("purchaseId", (Serializable)((Object)key.trim()), MatchMode.ANYWHERE);
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getOpTypes())) {
            builder.in("opType", txFinanceInfo.getOpTypes());
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getOpTos())) {
            builder.in("opTo", txFinanceInfo.getOpTos());
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getPayTypes())) {
            builder.in("payType", txFinanceInfo.getPayTypes());
        }
        if (page != null) {
            builder.setPage(page);
        }
        if (txFinanceInfo.getStartTime() != null && txFinanceInfo.getEndTime() != null) {
            builder.ge("createTime", (Serializable)txFinanceInfo.getStartTime());
            builder.lt("createTime", (Serializable)txFinanceInfo.getEndTime());
        }
        if (txFinanceInfo.getStartBalance() != null) {
            builder.ge("opMoney", (Serializable)txFinanceInfo.getStartBalance());
        }
        if (txFinanceInfo.getEndBalance() != null) {
            builder.le("opMoney", (Serializable)txFinanceInfo.getEndBalance());
        }
        builder.desc(new String[]{"createTime", "id"});
        log.info("TxxFinanceInfo list = {},{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }
}

