/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.export.dao.impl;

import com.baijia.tianxiao.dal.export.dao.TXLogStatEventDao;
import com.baijia.tianxiao.dal.export.dto.LogStatisticDto;
import com.baijia.tianxiao.dal.export.po.TXLogstatEvent;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TXLogStatEventDaoImpl
extends JdbcTemplateDaoSupport<TXLogstatEvent>
implements TXLogStatEventDao {
    @Override
    public Map<Long, LogStatisticDto> getLogStatisticDtoMap(List<Long> orgIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        String sql = "select user_id as org_id, count(distinct role_id) as login_account_total, count(distinct device_id) as login_device_total from db_statistics.tx_logstat_event where user_id is not null and role_id !=0 and role_type != 0 ";
        if (startTime != null) {
            sql = sql + "and pt between date_format(:startTime,'%Y%m%d') and date_format(:endTime,'%Y%m%d') ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by user_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, LogStatisticDto>>(){

            public Map<Long, LogStatisticDto> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, LogStatisticDto> map = new HashMap<Long, LogStatisticDto>();
                while (rs.next()) {
                    Integer loginAccountTotal = rs.getInt("login_account_total");
                    Integer loginDeviceTotal = rs.getInt("login_device_total");
                    Long orgId = rs.getLong("org_id");
                    LogStatisticDto dto = new LogStatisticDto();
                    dto.setLoginAccountTotal(loginAccountTotal);
                    dto.setLoginDeviceTotal(loginDeviceTotal);
                    map.put(orgId, dto);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgOpenTotalMap(List<Long> orgIds, Date startTime, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", orgIds);
        String sql = "select user_id as org_id, count(1) as org_open_total from db_statistics.tx_logstat_event where user_id is not null and statistic_id in ('tianxiao_app_start','tianxiao_app_foreground') and role_id !=0 and role_type != 0 ";
        if (startTime != null) {
            sql = sql + "and pt between date_format(:startTime,'%Y%m%d') and date_format(:endTime,'%Y%m%d') ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql = sql + " group by user_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Integer count = rs.getInt("org_open_total");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }
}

